<?php

/**
 * @package SliderResource
 * @author TechVillage <support@techvill.org>
 * @contributor Al Mamun <[almamun.techvill@gmail.com]>
 * @created 01-10-2022
 */

namespace Modules\CMS\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class SliderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request
     * @return array
     */
    public function toArray($request = [])
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'slug' => $this->slug,
            'slide' => SlideResource::collection($this->slides),
            'created' => timeZoneFormatDate($this->created_at) . ' ' . timeZoneGetTime($this->created_at),
            'updated' => timeZoneFormatDate($this->updated_at) . ' ' . timeZoneGetTime($this->updated_at),
            'status' => $this->status,
        ];
    }
}
