<?php
/**
 * @package AttributeGroupDetailResource
 * @author TechVillage <support@techvill.org>
 * @contributor Sakawat Hossain Rony <[sakawat.techvill@gmail.com]>
 * @created 26-10-2021
 */
namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class AttributeGroupDetailResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array
     */
    public function toArray($request = [])
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'vendor' => ['id' => $this->vendor_id, 'name' => optional($this->vendor)->name],
            'summary' => $this->summary,
            'status' => $this->status,
            'created_at' => $this->format_created_at,
        ];
    }
}
