<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWalletsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('wallets', function (Blueprint $table)
        {
            $table->increments('id');

            $table->bigInteger('user_id')->index();
            $table->integer('currency_id')->unsigned()->index()->nullable();
            $table->decimal('balance', 20, 8)->default(0.00000000);

            $table->unique(['user_id', 'currency_id']);

            $table->boolean('is_default')->default(false);

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('wallets');
    }
}
