<header class="navbar pcoded-header navbar-expand-lg navbar-light">
    <div class="m-header header-background-color">
        <a class="mobile-menu" id="mobile-collapse1" href="javascript:"><span></span></a>
        <a href="{{ route('dashboard') }}" class="b-brand text-decoration-none">
            <span class="b-title">{{ trimWords(preference('company_name'), 17) }}</span>
        </a>
    </div>
    <a class="mobile-menu text-decoration-none" id="mobile-header" href="javascript:">
        <i class="feather icon-more-horizontal"></i>
    </a>
    <div class="collapse navbar-collapse">
        <ul class="navbar-nav d-flex flex-row flex-wrap nav-menu {{ languageDirection() == 'ltr' ? 'float-left me-auto ms-2' : 'float-right ms-auto me-2' }}">
            <li><a href="javascript:" class="full-screen text-decoration-none {{ languageDirection() == 'ltr' ? 'ps-2' : 'pe-2' }}" onclick="javascript:toggleFullScreen()"><i class="feather icon-maximize"></i></a></li>
            <li class="nav-menu-home nav-parent">
                <a class="d-flex align-items-center hover_line text-decoration-none" href="{{ route('site.index') }}" target="_blank">
                    <i class="far fa-arrow-alt-circle-left fa-lg"></i>
                    <span class="list-curent-color {{ languageDirection() == 'ltr' ? 'ms-2' : 'me-2' }}">{{ __('Visit Site') }}</span>
                </a>
            </li>
            <li class="{{ languageDirection() == 'ltr' ? 'ms-3' : 'me-3' }} nav-parent">
                <a class="d-flex hover_line align-items-center text-decoration-none" href="{{ route('site.dashboard') }}" target="_blank">
                    <i class="fas fa-external-link-alt fa-lg"></i>
                    <span class="{{ languageDirection() == 'ltr' ? 'ms-2' : 'me-2' }} list-curent-color">{{ __('Customer Panel') }}</span>
                </a>
            </li>
            @if (auth()->user()->role()->slug == 'super-admin' || auth()->user()->role()->slug == 'vendor-admin')
                <li class="{{ languageDirection() == 'ltr' ? 'ms-lg-3' : 'me-lg-3' }} nav-parent">
                    <a class="d-flex align-items-center text-decoration-none hover_line" href="{{ route('vendor-dashboard') }}" target="_blank">
                        <i class="fas fa-external-link-alt fa-lg"></i>
                        <span class="{{ languageDirection() == 'ltr' ? 'ms-2' : 'me-2' }} list-curent-color">{{ __('Vendor Panel') }}</span>
                    </a>
                </li>
            @endif
            @if (auth()->user()->role()->slug == 'super-admin')
                @includeIf('affiliate::layouts.includes.admin_panel_header')
            @endif
        </ul>
        @php
            $flag = config('app.locale');
        @endphp
        <ul class="navbar-nav nav-icon {{ languageDirection() == 'ltr' ? 'ms-lg-auto ms-2 me-lg-2' : 'me-lg-auto me-2 ms-lg-2' }}">
            @php
                $languages = \App\Models\Language::getAll()->where('status', 'Active');
            @endphp

            @if (in_array('App\Http\Controllers\DashboardController@switchLanguage', $prms) && $languages->isNotEmpty())
                <li>
                    <div class="dropdown">
                        <a class="dropdown-toggle flag flag-icon-background flag-icon-{{ getSVGFlag($flag) }}" id="dropdown-flag" data-bs-toggle="dropdown" href="javascript:" ></a>
                        <div class="dropdown-menu dropdown-menu-right notification">
                            <div class="noti-head">
                                <h6 class="d-inline-block m-b-0">{{ __('Select Language') }}</h6>
                            </div>
                            <ul class="noti-body scroll-noti">
                                @foreach ($languages as $language)
                                    <li class="notification">
                                        <div class="media lang d-flex" id="{{ $language->short_name }}" data-shortname="{{ $language->short_name }}">
                                            <img class="img-radius" src='{{ url("public/datta-able/fonts/flag/flags/4x3/" . getSVGFlag($language->short_name) . ".svg") }}' alt="{{ $language->flag }}">
                                            <div class="media-body">
                                                <p><span>{{ $language->name }}</span></p>
                                            </div>
                                        </div>
                                    </li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                </li>
            @endif
            <li class="{{ languageDirection() == 'ltr' ? 'me-2' : 'ms-2' }}">
                <div class="dropdown drp-user">
                    <a href="javascript:void(0)" class="dropdown-toggle text-decoration-none" data-bs-toggle="dropdown">
                        <i class="icon feather icon-settings {{ languageDirection() == 'ltr' ? 'ms-0' : 'me-0' }} f-20"></i>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right profile-notification">
                        <div class="pro-head">
                            <img src="{{ Auth::user()->fileUrl() }}" class="img-radius" alt="User-Profile-Image">
                            <span>{{ Auth::user()->name }}</span>
                            @if (in_array('App\Http\Controllers\LoginController@logout', $prms))
                                <a href="{{ route('users.logout') }}" class="dud-logout" title="Logout">
                                    <i class="feather icon-log-out"></i>
                                </a>
                            @endif
                        </div>
                        <ul class="pro-body">
                            <li><a href="{{ route('users.profile') }}" class="dropdown-item text-decoration-none"><i class="feather icon-user"></i> {{ __('Profile') }}</a></li>
                            <li><a href="{{ route('users.activity') . '?userId=' . \Auth::id() }}" class="dropdown-item text-decoration-none"><i class="feather icon-activity"></i> {{ __('Login Activities') }}</a></li>
                            @if (in_array('App\Http\Controllers\LoginController@logout', $prms))
                                <li><a href="{{ route('users.logout') }}" class="dropdown-item text-decoration-none"><i class="feather icon-lock"></i> {{ __('Sign Out') }}</a></li>
                            @endif
                        </ul>
                    </div>
                </div>
            </li>
        </ul>
    </div>
</header>
