@extends('../site/layouts.user_panel.app')
@section('page_title', __('Dashboard'))
@section('content')
    <div class="dark:bg-red-1 h-full xl:px-74p px-5 pt-30p xl:pt-14 bg-white" id="user-dashboard-container">
        <div class="mb-16">
            <div class="flex lg:items-center">
                <span class="lg:mt-0 mt-1 {{ languageDirection() == 'ltr' ? 'mr-4' : 'ml-4' }}">
                    <svg class="h-30p w-10 xl:w-53p xl:h-11 neg-transition-scale" xmlns="http://www.w3.org/2000/svg" width="53" height="44" viewBox="0 0 53 44" fill="none">
                        <rect x="36.1779" y="27.377" width="16.6222" height="16.6222" rx="2" fill="#FCCA19" />
                        <rect width="32.2667" height="32.2667" rx="2" fill="#FCCA19" />
                    </svg>
                </span>
                <h1 class="dm-sans font-medium lg:pt-0 text-2xl xl:text-4xl text-gray-12 mb-1 dark:text-gray-2">
                    <span class="welcome-message"></span>, {{ auth()->user()->name }}
                </h1>
            </div>
            <p class="dark:text-gray-2 lg:mt-1.5 roboto-medium font-medium text-base xl:text-xl text-gray-10 leading-6">{{ __("Here is what's happening with your profile today..") }}</p>
        </div>
        <div class="grid 2xl:gap-11 gap-15p mb-8 grid-cols-2 2xl:grid-cols-4">
            <!-- Card -->
            <a href="{{ route('site.order') }}" class="bg-yellow-4 border border-yellow-1 flex items-center rounded dark:bg-gray-800 py-5 2xl:py-7 {{ languageDirection() == 'ltr' ? '2xl:pl-11 lg:pl-4 md:pl-4 pl-4 pr-2' : '2xl:pr-11 lg:pr-4 md:pr-4 pr-4 pl-2' }}">
                    <span  class="w-35p h-8 lg:w-65p lg:h-16 {{ languageDirection() == 'ltr' ? '2xl:mr-4 lg:mr-15p mr-2.5' : '2xl:ml-4 lg:ml-15p ml-2.5' }}">
                        <svg class="h-full w-full neg-transition-scale" xmlns="http://www.w3.org/2000/svg" width="65" height="64" viewBox="0 0 65 64" fill="none">
                        <rect x="41.8901" y="44.4355" width="19.2468" height="19.2468" rx="2" fill="#FCCA19" />
                        <rect y="12.7363" width="37.3614" height="37.3614" rx="2" fill="#FCCA19" />
                        <path d="M10.0375 0.187667C9.59999 0.287667 8.87499 0.537667 8.41249 0.762667C7.25 1.32517 5.7 2.87517 5.15 4.02517C4.325 5.71267 4.375 4.20016 4.4 30.5252L4.4375 54.4377L4.7 55.0127C5.05 55.7627 5.8625 56.5752 6.6125 56.9252C7.175 57.1877 7.2875 57.1877 15.875 57.2252C20.65 57.2377 24.7 57.2252 24.85 57.1877C25.325 57.0752 25.75 56.5252 25.75 56.0377C25.75 55.5752 25.4875 55.0877 25.15 54.9127C25.0375 54.8627 21.0375 54.7877 16.2875 54.7502L7.62499 54.6877L7.2875 54.3377L6.9375 54.0002V30.1502C6.9375 7.75016 6.95 6.27517 7.1625 5.68767C7.4625 4.82517 8.18749 3.90017 8.99999 3.35017C10.325 2.45017 9.075 2.50017 30.0375 2.50017H48.8875L48.525 3.02517C48.0625 3.70017 47.6625 4.48767 47.4 5.23767C47.2125 5.76267 47.1875 7.81266 47.125 27.0002L47.0625 48.1877L46.775 48.6502C46.4625 49.1627 45.6375 49.6252 45.05 49.6252C44.5375 49.6127 43.7125 49.2252 43.4 48.8252C43.2625 48.6377 42.6625 47.0377 42.0625 45.2502C40.9125 41.8127 40.65 41.3002 39.725 40.6252C38.1875 39.5127 35.9875 39.7252 34.65 41.1377C34.025 41.7877 33.6875 42.6252 33.5625 43.8377L33.475 44.7502H30.1625C27.975 44.7502 26.7625 44.8002 26.5875 44.8877C25.65 45.3752 25.65 46.6252 26.5875 47.1127C26.7625 47.2002 27.975 47.2502 30.175 47.2502H33.5V50.0252C33.5 53.2377 33.6625 55.5502 33.9375 56.6627C34.2625 57.8877 34.7875 59.2377 36.575 63.4502C36.6125 63.5127 36.8 63.6752 37.0125 63.8002C37.5375 64.1127 38.1375 63.9752 38.5625 63.4752C39.0125 62.9377 38.9625 62.6752 37.8375 60.0002C36.8125 57.5627 36.4375 56.5002 36.25 55.5252C36.1625 55.0127 36.0875 49.3877 36.125 44.0377C36.125 43.4002 36.175 43.2002 36.45 42.8877C37 42.2252 38.125 42.2502 38.575 42.9377C38.675 43.0877 39.225 44.6252 39.8125 46.3752C40.4 48.1127 40.9875 49.7127 41.1125 49.9252C41.825 51.0627 43.2875 51.9752 44.6 52.0877C46.1625 52.2377 47.875 51.4252 48.775 50.1127C49.65 48.8252 49.625 49.2002 49.625 37.0127V26.0752L50.0125 26.4502C50.825 27.2002 52.725 29.3752 53.1625 30.0377C54.35 31.8252 55.1375 33.6752 55.5875 35.7502C55.7875 36.7252 55.8125 37.5752 55.8125 45.8127C55.8125 54.0002 55.7875 54.9252 55.5875 56.1127C55.3 57.7377 54.7625 59.5502 54.1 61.1877C53.5125 62.5877 53.475 62.9877 53.8375 63.4752C54.325 64.1377 55.3625 64.1127 55.8 63.4377C56.3125 62.6502 57.3 59.8877 57.75 57.9627C58.3125 55.5627 58.375 54.4502 58.375 45.6627C58.375 35.6502 58.325 35.1752 57.0125 31.9502C55.9625 29.3752 54.8875 27.8877 51.85 24.8002L49.625 22.5377V21.9627V21.3877L54.225 21.3502C58.6125 21.3127 58.8375 21.3002 59.3875 21.0502C60.1375 20.7002 60.95 19.8877 61.3 19.1377C61.55 18.5752 61.5625 18.4002 61.6 12.6127C61.6375 5.98767 61.6 5.56267 60.85 4.02517C60.3 2.87517 58.75 1.32517 57.6 0.775167C55.925 -0.0373335 57.2625 0.000166517 32.9375 0.0126665C14.7875 0.0126665 10.675 0.0501665 10.0375 0.187667ZM56 2.81267C56.8 3.08767 57.7375 3.83767 58.275 4.62517C59.1125 5.83767 59.1375 6.13767 59.1 12.4877L59.0625 18.1252L58.7125 18.4627L58.375 18.8127L53.9875 18.8502L49.6125 18.8877L49.65 12.5377C49.6875 6.86267 49.7125 6.12517 49.9125 5.62517C50.425 4.30017 51.775 3.06267 53.125 2.68767C53.9375 2.46267 55.1625 2.51267 56 2.81267Z" fill="#2C2C2C" />
                        <path d="M12.5625 6.9875C11.9625 7.2625 11.575 7.6625 11.3125 8.275C11.0375 8.9625 11.0375 15.0375 11.3125 15.725C11.575 16.3375 11.9625 16.7375 12.5625 17.0125C13.0125 17.225 13.425 17.25 16.2875 17.25C19.8375 17.25 20.075 17.2125 20.85 16.4625C21.525 15.8125 21.625 15.2125 21.625 12C21.625 8.7875 21.525 8.1875 20.85 7.5375C20.075 6.7875 19.8375 6.75 16.2875 6.75C13.425 6.75 13.0125 6.775 12.5625 6.9875ZM19.125 12V14.75H16.375H13.625V12V9.25H16.375H19.125V12Z" fill="#2C2C2C" />
                        <path d="M26.5625 14.8876C25.6375 15.4251 25.65 16.6376 26.6125 17.1251C27.5125 17.5876 28.6 16.5376 28.2 15.5876C28.1125 15.3626 27.95 15.1126 27.8375 15.0251C27.5625 14.8001 26.8625 14.7251 26.5625 14.8876Z" fill="#2C2C2C" />
                        <path d="M32.3 14.8753C31.6 15.1503 31.4 16.2253 31.925 16.8378L32.225 17.1878L36.8375 17.2253C39.3625 17.2503 41.575 17.2253 41.725 17.1878C41.8875 17.1503 42.1625 16.9628 42.325 16.7878C42.8625 16.2128 42.6625 15.2753 41.9125 14.8878C41.5875 14.7253 32.7125 14.7128 32.3 14.8753Z" fill="#2C2C2C" />
                        <path d="M12.5625 21.9875C11.9625 22.2625 11.575 22.6625 11.3125 23.275C11.0375 23.9625 11.0375 30.0375 11.3125 30.725C11.575 31.3375 11.9625 31.7375 12.5625 32.0125C13.0125 32.225 13.425 32.25 16.2875 32.25C19.8375 32.25 20.075 32.2125 20.85 31.4625C21.525 30.8125 21.625 30.2125 21.625 27C21.625 23.7875 21.525 23.1875 20.85 22.5375C20.075 21.7875 19.8375 21.75 16.2875 21.75C13.425 21.75 13.0125 21.775 12.5625 21.9875ZM19.125 27V29.75H16.375H13.625V27V24.25H16.375H19.125V27Z" fill="#2C2C2C" />
                        <path d="M26.5625 29.9002C25.6375 30.4002 25.65 31.6377 26.5875 32.1127C26.975 32.3127 41.525 32.3127 41.9125 32.1127C42.35 31.8877 42.625 31.4752 42.625 31.0002C42.625 30.5252 42.35 30.1127 41.9125 29.8877C41.5375 29.7002 26.9125 29.7002 26.5625 29.9002Z" fill="#2C2C2C" />
                        <path d="M12.5625 36.9875C11.9625 37.2625 11.575 37.6625 11.3125 38.275C11.0375 38.9625 11.0375 45.0375 11.3125 45.725C11.575 46.3375 11.9625 46.7375 12.5625 47.0125C13.0125 47.225 13.425 47.25 16.2875 47.25C19.8375 47.25 20.075 47.2125 20.85 46.4625C21.525 45.8125 21.625 45.2125 21.625 42C21.625 38.7875 21.525 38.1875 20.85 37.5375C20.075 36.7875 19.8375 36.75 16.2875 36.75C13.425 36.75 13.0125 36.775 12.5625 36.9875ZM19.125 42V44.75H16.375H13.625V42V39.25H16.375H19.125V42Z" fill="#2C2C2C" />
                        <path d="M29.225 55.1125C28.3875 55.8625 28.875 57.1875 30 57.1875C31.125 57.1875 31.6125 55.8625 30.775 55.1125C30.525 54.8875 30.2375 54.75 30 54.75C29.7625 54.75 29.475 54.8875 29.225 55.1125Z" fill="#2C2C2C" />
                    </svg>
                    </span>
                <div class="flex flex-col lg:py-0 py-3 justify-center">
                    <span class="roboto-regular font-regular text-gray-12 text-xs md:text-base lg:text-base xl:text-lg dark:text-white leading-none lg:leading-5">{{ __('Total Order') }}</span>
                    <div class="dm-sans font-medium text-gray-12 text-2xl lg:text-34 dark:text-gray-2 leading-none lg:leading-10">
                        {{ auth()->user()->totalOrder() }}
                    </div>
                </div>
            </a>
            <!-- Card -->
            <a href="{{ route('site.wishlist') }}" class="bg-gray-11 border border-gray-10 flex items-center rounded dark:bg-gray-800 py-5 2xl:py-7 {{ languageDirection() == 'ltr' ? '2xl:pl-11 lg:pl-4 md:pl-4 pl-4 pr-2' : '2xl:pr-11 lg:pr-4 md:pr-4 pr-4 pl-2' }}">
                <span class="w-38p h-9 lg:w-70p lg:h-16 {{ languageDirection() == 'ltr' ? '2xl:mr-4 lg:mr-15p mr-2.5' : '2xl:ml-4 lg:ml-15p ml-2.5' }}">
                     <svg class="h-full w-full neg-transition-scale" xmlns="http://www.w3.org/2000/svg" width="71" height="64" viewBox="0 0 71 64" fill="none">
                    <rect x="41.8901" y="42.4355" width="19.2468" height="19.2468" rx="2" fill="#FCCA19" />
                    <rect y="10.7363" width="37.3614" height="37.3614" rx="2" fill="#FCCA19" />
                    <path d="M10.8125 0.212402C10 0.512402 9.4375 0.912403 8.9875 1.5374C8.4125 2.3374 8.25 3.0874 8.25 4.9749C8.25 6.4624 8.225 6.6874 8 6.9999C7.85 7.1999 7.5875 7.6874 7.4 8.0874L7.0625 8.8124L7.025 29.9999C7 48.8249 7.0125 51.3374 7.1875 52.5499C7.5875 55.2624 8.7125 57.9999 10.3 60.0749C10.7375 60.6499 10.75 60.6874 10.75 61.8249C10.75 63.1249 10.8875 63.5624 11.3875 63.8249C11.825 64.0499 12.175 64.0499 12.6125 63.8249C13.1125 63.5624 13.25 63.1249 13.25 61.8249C13.25 60.6874 13.2625 60.6499 13.7 60.0749C15.275 58.0124 16.4 55.2874 16.8 52.5999C16.975 51.4499 17 48.9999 17 33.1374V14.9999H17.75C18.625 14.9999 19.1375 15.2124 19.35 15.6874C19.4625 15.9249 19.5 17.6249 19.5 22.0124C19.5 28.5249 19.5 28.5374 20.1875 28.8499C20.85 29.1499 21.6125 28.8999 21.8625 28.2874C21.975 28.0249 22 26.2374 21.975 21.6249C21.9375 15.5124 21.925 15.2999 21.675 14.7374C21.0125 13.3124 19.875 12.6124 18.1125 12.5249L17.025 12.4749L16.975 10.6374C16.9375 8.9749 16.9 8.7499 16.6 8.0874C16.4125 7.6874 16.15 7.2124 16.0125 7.0249C15.8125 6.7249 15.7625 6.4124 15.725 4.7499C15.675 2.5999 15.5375 2.1124 14.7625 1.2124C13.875 0.199902 12.1 -0.250099 10.8125 0.212402ZM12.6125 2.6749C13.075 2.9249 13.25 3.3624 13.25 4.2874V5.0624H12H10.75V4.2499C10.7625 3.3624 10.9375 2.9249 11.3875 2.6749C11.775 2.4624 12.1875 2.4624 12.6125 2.6749ZM13.375 7.9249C13.6375 8.0874 13.975 8.4499 14.1375 8.7124C14.4125 9.1374 14.4375 9.3624 14.475 10.8374L14.525 12.4999H12.0125H9.5V11.0874C9.5 10.3249 9.5625 9.4749 9.6375 9.2124C9.8 8.6374 10.5875 7.7999 11.15 7.6374C11.8125 7.4374 12.8375 7.5624 13.375 7.9249ZM14.5 31.9999V48.9999H12H9.5V31.9999V14.9999H12H14.5V31.9999ZM14.3375 52.2124C14.175 53.7749 13.0625 56.7374 12.25 57.7499L12 58.0624L11.75 57.7499C10.9375 56.7374 9.825 53.7749 9.6625 52.2124L9.5875 51.4999H12H14.4125L14.3375 52.2124Z" fill="#2C2C2C" />
                    <path d="M29.2875 9.17494C27.025 9.72494 25.1125 11.6999 24.6375 13.9749C24.5375 14.4374 24.5 20.4374 24.5 34.3124V53.9999H22.5C20.325 53.9999 19.9625 54.0874 19.675 54.6374C19.275 55.4249 19.6125 57.4249 20.45 59.1249C20.9375 60.1124 21.225 60.4999 22.1125 61.3874C23.0125 62.2874 23.3875 62.5624 24.375 63.0374C26.4625 64.0624 25.5125 64.0124 43.0625 63.9749L58.5625 63.9374L59.275 63.6499C60.875 62.9999 62.05 61.9374 62.8 60.4249C63.525 58.9749 63.5 59.8124 63.5 39.8374V21.4999H66.75C70.3375 21.4999 70.5875 21.4499 70.8625 20.7749C70.975 20.5124 71 19.3749 70.975 16.6124L70.9375 12.8124L70.5375 11.9749C69.9875 10.8124 69.2875 10.0874 68.15 9.52494L67.2 9.06244L48.575 9.03744C33.9625 9.02494 29.8 9.04994 29.2875 9.17494ZM61.3375 12.1499L61.0625 12.8124L61 35.6874L60.9375 58.5624L60.5875 59.2749C60.1125 60.2374 59.1875 61.0624 58.275 61.3249C56.5 61.8499 54.6125 60.9624 53.825 59.2624C53.6125 58.7749 53.5625 58.3874 53.525 56.8749C53.5125 55.8749 53.425 54.8999 53.35 54.7124C53.0625 53.9624 53.6875 53.9999 39.75 53.9999H27V34.3999C27 12.8874 26.9625 14.1124 27.75 13.0249C28.1625 12.4499 28.8625 11.9374 29.5875 11.6749C29.975 11.5374 32.9 11.5124 45.8375 11.4999H61.625L61.3375 12.1499ZM67.375 11.9249C67.6375 12.0874 67.975 12.4499 68.1375 12.7124C68.425 13.1749 68.4375 13.2874 68.475 16.0874L68.5125 18.9999H66.0125H63.5V16.3374C63.5 14.8624 63.5625 13.4749 63.6375 13.2124C63.8 12.6374 64.5875 11.7999 65.15 11.6374C65.8125 11.4374 66.8375 11.5624 67.375 11.9249ZM51.025 57.7749C51.1 59.1624 51.375 60.1749 51.9375 61.0249L52.25 61.4999H39.9C26.45 61.4999 26.9 61.5249 25.375 60.7874C24.025 60.1374 22.5375 58.2874 22.2 56.8374L22.125 56.4999H36.5375H50.9625L51.025 57.7749Z" fill="#2C2C2C" />
                    <path d="M38.2625 16.6999C36.3375 17.2124 34.7125 18.9249 34.2625 20.8874C34.0625 21.7249 34.1 23.3749 34.325 24.1374C34.9875 26.3624 36.1625 27.7249 41 31.8749C43.575 34.0874 43.8375 34.2249 44.525 33.8624C45.075 33.5749 50 29.2249 51.125 28.0374C52.3625 26.7374 52.9375 25.9124 53.475 24.5999C53.7625 23.9124 53.8 23.6374 53.8 22.4374C53.8 21.2999 53.75 20.9249 53.5 20.3124C52.9125 18.7749 52.0125 17.7499 50.6875 17.0749C48.5625 16.0124 46.225 16.4249 44.525 18.1624L43.9875 18.7124L43.325 18.0624C41.9625 16.6999 40.1125 16.1999 38.2625 16.6999ZM40.575 19.1874C41.5 19.5749 42.325 20.5249 42.7 21.6499C42.925 22.3374 43.425 22.7499 44.025 22.7499C44.475 22.7499 45.0375 22.2124 45.3 21.5124C45.775 20.2624 46.6375 19.3749 47.625 19.1124C49.675 18.5624 51.55 20.4249 51.3375 22.7874C51.1875 24.4624 49.9875 25.9624 46.2125 29.1999L43.975 31.1124L41.975 29.3999C38.55 26.4874 37.3625 25.1999 36.85 23.8499C36.6 23.1749 36.55 21.9499 36.75 21.2249C37.2 19.6374 39.15 18.5874 40.575 19.1874Z" fill="#2C2C2C" />
                    <path d="M32.6375 39.175C31.55 39.775 32.0125 41.5 33.25 41.5C33.8875 41.5 34.5 40.8875 34.5 40.2625C34.5 39.325 33.4625 38.7125 32.6375 39.175Z" fill="#2C2C2C" />
                    <path d="M37.6375 39.1749C36.8 39.6374 36.825 40.9624 37.6875 41.3499C38.15 41.5624 54.85 41.5624 55.3125 41.3499C55.675 41.1874 56 40.6624 56 40.2499C56 39.8374 55.675 39.3124 55.3125 39.1499C54.8125 38.9249 38.05 38.9499 37.6375 39.1749Z" fill="#2C2C2C" />
                    <path d="M32.6375 46.675C31.55 47.275 32.0125 49 33.25 49C33.8875 49 34.5 48.3875 34.5 47.7625C34.5 46.825 33.4625 46.2125 32.6375 46.675Z" fill="#2C2C2C" />
                    <path d="M37.6375 46.6749C36.8 47.1374 36.825 48.4624 37.6875 48.8499C38.15 49.0624 54.85 49.0624 55.3125 48.8499C55.675 48.6874 56 48.1624 56 47.7499C56 47.3374 55.675 46.8124 55.3125 46.6499C54.8125 46.4249 38.05 46.4499 37.6375 46.6749Z" fill="#2C2C2C" />
                </svg>
                </span>

                <div class="flex lg:py-0 py-3 flex-col justify-center">
                    <span class="roboto-regular font-regular text-gray-12 text-xs md:text-base lg:text-base xl:text-lg dark:text-white leading-none lg:leading-5">{{ __('Your Wishlist') }}</span>
                    <div class="dm-sans font-medium text-gray-12 lg:text-34 text-2xl dark:text-gray-2 leading-none lg:leading-10 ">{{ auth()->user()->totalWishlist() }}</div>
                </div>
            </a>
            <!-- Card -->
            <a href="{{ route('site.review') }}" class=" bg-yellow-4 border border-yellow-1 flex items-center rounded dark:bg-gray-800 py-5 2xl:py-7 {{ languageDirection() == 'ltr' ? '2xl:pl-11 lg:pl-4 md:pl-4 pl-4 pr-2' : '2xl:pr-11 lg:pr-4 md:pr-4 pr-4 pl-2' }}">
                <span class="w-9 h-35p lg:w-70p lg:h-16 {{ languageDirection() == 'ltr' ? '2xl:mr-4 lg:mr-15p mr-2.5' : '2xl:ml-4 lg:ml-15p ml-2.5' }}">
                    <svg class="h-full w-full neg-transition-scale" xmlns="http://www.w3.org/2000/svg" width="69" height="64" viewBox="0 0 69 64" fill="none">
                    <rect x="41.8901" y="37.6992" width="19.2468" height="19.2468" rx="2" fill="#FCCA19" />
                    <rect y="6" width="37.3614" height="37.3614" rx="2" fill="#FCCA19" />
                    <g clip-path="url(#clip0_1193_3340)">
                        <path d="M9.3875 0.199707C7.2625 0.774706 5.5875 2.49971 5.1375 4.59971C4.95 5.51221 4.95 20.9747 5.1375 21.8997C5.5375 23.8122 7.0125 25.4872 8.9125 26.2122C9.2875 26.3622 10.075 26.4372 11.75 26.4872L14.0625 26.5622L16.3125 29.5622L18.5625 32.5622L19.0875 32.5997L19.6125 32.6372L21.9 29.5747L24.1875 26.5122L44.0625 26.4997C56.9875 26.4997 64.125 26.4497 64.4875 26.3622C66.625 25.8747 68.475 23.9372 68.875 21.7622C69.05 20.8497 69.0375 5.62471 68.875 4.73721C68.575 3.13721 67.4 1.49971 66.025 0.774706C64.475 -0.050293 66 -0.000293732 42.375 -0.000293732C20.9625 -0.000293732 20.925 -0.000293732 20.65 0.249706C20.325 0.549706 20.2875 1.19971 20.55 1.57471C20.725 1.81221 21.1375 1.81221 42.4625 1.87471L64.1875 1.93721L64.9 2.28721C65.7 2.67471 66.4 3.39971 66.8 4.24971C67.0625 4.81221 67.0625 4.89971 67.0625 13.2497V21.6872L66.7125 22.3997C66.2875 23.2747 65.45 24.0372 64.55 24.3747C63.875 24.6247 63.675 24.6247 43.6875 24.6247H23.525L23.1625 24.9247C22.975 25.0872 22 26.3247 21 27.6747C20 29.0122 19.1625 30.1122 19.125 30.1247C19.0875 30.1247 18.2 28.9872 17.1625 27.5872C16.1125 26.1872 15.175 24.9622 15.05 24.8622C14.8875 24.7247 14.2375 24.6747 12.2625 24.6247C9.775 24.5622 9.6625 24.5497 9.0625 24.2247C8.25 23.7997 7.475 22.9622 7.175 22.1747C6.95 21.5997 6.9375 21.1247 6.9375 13.1872V4.81221L7.2875 4.09971C7.6875 3.28721 8.4 2.58721 9.2375 2.19971C9.775 1.96221 10.075 1.93721 13.4125 1.87471C16.8 1.81221 17.0375 1.79971 17.2 1.57471C17.4875 1.16221 17.425 0.549706 17.05 0.262207C16.725 0.012207 16.575 -0.000293732 13.3875 0.012207C10.9 0.012207 9.8875 0.0622063 9.3875 0.199707Z" fill="black" />
                        <path d="M18.2875 6.425C18.075 6.6125 17.625 7.375 17.15 8.4L16.3625 10.0875L14.4625 10.3625C12.4 10.675 12 10.8125 11.775 11.3125C11.4125 12.1 11.5625 12.375 13.2625 14L14.6375 15.3125L14.3125 17.05C14.1375 18.0125 14 18.975 14 19.175C14.0125 19.8125 14.625 20.375 15.3 20.375C15.475 20.375 16.3875 19.975 17.3375 19.475L19.05 18.575L20.8125 19.475C21.775 19.975 22.6875 20.375 22.85 20.375C23.325 20.375 23.825 20.0375 24.0125 19.6125C24.15 19.25 24.1375 18.975 23.8375 17.2625L23.5 15.3125L24.8625 14C26.5625 12.375 26.7125 12.1 26.35 11.3125C26.125 10.8125 25.7 10.6625 23.65 10.3625L21.7625 10.075L20.95 8.3625C20.45 7.325 20 6.55 19.8 6.3875C19.35 6.0375 18.7375 6.05 18.2875 6.425ZM19.8 10.225C20.225 11.075 20.5875 11.625 20.7625 11.725C21.0125 11.85 23.2875 12.25 23.775 12.25C23.85 12.25 23.4 12.775 22.775 13.425C21.475 14.75 21.4875 14.675 21.8125 16.5C22.1 18.125 22.175 18.075 20.725 17.3C20.0125 16.9375 19.275 16.625 19.075 16.625C18.8625 16.625 18.1375 16.925 17.4125 17.3125C15.95 18.0875 16.025 18.1375 16.3125 16.5C16.6375 14.675 16.65 14.75 15.35 13.425C14.725 12.775 14.275 12.25 14.35 12.25C14.8375 12.25 17.1125 11.85 17.3625 11.725C17.5375 11.625 17.9 11.075 18.325 10.225C18.7 9.475 19.025 8.875 19.0625 8.875C19.1 8.875 19.425 9.475 19.8 10.225Z" fill="black"/>
                        <path d="M36.325 6.32499C36.05 6.47499 35.775 6.93749 35.1 8.32499C34.625 9.31249 34.1875 10.125 34.125 10.125C33.5375 10.125 30.375 10.6875 30.15 10.8375C29.775 11.0625 29.4875 11.7375 29.5875 12.1375C29.625 12.3 30.3 13.0875 31.0875 13.8875L32.525 15.35L32.2 17.2875C31.85 19.4125 31.8625 19.65 32.45 20.1125C32.9875 20.5375 33.4 20.45 35.2625 19.4625L36.9875 18.5625L38.725 19.4625C40.5375 20.4125 40.975 20.525 41.4875 20.175C42.0875 19.75 42.125 19.375 41.775 17.275L41.4625 15.3625L42.9125 13.8875C44.3125 12.475 44.375 12.3875 44.375 11.8875C44.375 11.0375 43.9375 10.7 42.625 10.5125C42.0375 10.425 41.15 10.3 40.65 10.225L39.7375 10.0875L38.8125 8.26249C38.125 6.87499 37.825 6.38749 37.5625 6.27499C37.1375 6.07499 36.7625 6.08749 36.325 6.32499ZM37.7125 10.1875C38.075 10.9 38.5 11.575 38.6625 11.675C38.8125 11.7875 39.5625 11.9625 40.3125 12.075C41.075 12.1875 41.7125 12.3 41.75 12.3375C41.7875 12.375 41.325 12.8625 40.725 13.425C40.125 13.9875 39.6125 14.5875 39.5625 14.7625C39.525 14.925 39.6 15.7125 39.7375 16.5C39.8875 17.275 40 17.9375 40 17.9625C40 17.9875 39.4 17.7 38.6625 17.3125C37.925 16.9375 37.1625 16.625 36.975 16.625C36.7875 16.625 36.05 16.9375 35.325 17.325C34.5875 17.7125 34 17.975 34 17.9125C34 17.85 34.1125 17.1875 34.25 16.4375C34.3875 15.6875 34.4625 14.9625 34.425 14.8125C34.3875 14.675 33.85 14.05 33.225 13.425L32.1125 12.2875L33.575 12.0875C34.3875 11.975 35.175 11.7875 35.3375 11.6875C35.5 11.575 35.925 10.9 36.2875 10.1875C36.6375 9.46249 36.9625 8.87499 37 8.87499C37.0375 8.87499 37.3625 9.46249 37.7125 10.1875Z" fill="black"/>
                        <path d="M54.2125 6.37483C54 6.53733 53.5125 7.33733 53 8.37483L52.1375 10.0873L50.7875 10.2873C50.05 10.4123 49.175 10.5373 48.8375 10.5748C47.8875 10.7123 47.3625 11.3873 47.55 12.2123C47.6 12.4373 48.1625 13.0748 49.05 13.9373L50.475 15.3123L50.175 16.9998C49.775 19.2623 49.7875 19.5498 50.2375 20.0123C50.8 20.5748 51.175 20.4998 53.1875 19.4748L54.95 18.5748L56.6625 19.4748C58.4375 20.4123 58.775 20.4998 59.3625 20.1873C60.0375 19.8498 60.0875 19.4623 59.7 17.2623L59.3625 15.3123L60.725 13.9998C62.0875 12.6873 62.375 12.3248 62.375 11.9373C62.375 11.5498 61.9875 10.9123 61.6875 10.7748C61.5125 10.6873 60.5375 10.5123 59.5125 10.3623L57.6625 10.0873L56.8 8.34983C56.325 7.38733 55.8375 6.52483 55.725 6.41233C55.3625 6.08733 54.6125 6.06233 54.2125 6.37483ZM55.65 10.1998C56 10.9248 56.4 11.5873 56.55 11.6873C56.6875 11.7748 57.475 11.9498 58.2875 12.0748L59.75 12.2873L58.625 13.4373C57.3375 14.7498 57.35 14.7123 57.6875 16.6248C57.7875 17.2123 57.875 17.7623 57.875 17.8498C57.875 17.9373 57.35 17.7248 56.5875 17.3123C55.85 16.9248 55.1375 16.6248 54.925 16.6248C54.725 16.6248 53.975 16.9373 53.2625 17.3123C52.55 17.6873 51.95 17.9998 51.9375 17.9998C51.925 17.9998 52.0125 17.3998 52.15 16.6498C52.4875 14.7373 52.4625 14.6498 51.1625 13.3498C50.5625 12.7498 50.1375 12.2498 50.225 12.2498C50.6625 12.2498 52.9 11.8623 53.175 11.7373C53.4 11.6248 53.7 11.1873 54.1875 10.2248C54.575 9.48733 54.9125 8.87483 54.95 8.87483C54.9875 8.87483 55.3 9.47482 55.65 10.1998Z" fill="black"/>
                        <path d="M17.0625 35.9999C9.42499 37.1999 4.08749 44.2749 5.13749 51.8249C5.86249 57.0749 9.58749 61.5749 14.5875 63.2499C16.7375 63.9624 18.925 64.1499 21.1625 63.8124C24.2375 63.3499 26.6625 62.1124 28.95 59.8249C30.275 58.4999 30.875 57.6624 31.6625 56.1249C33.975 51.5374 33.4625 45.7874 30.3625 41.5999C29.475 40.4124 27.675 38.7499 26.475 38.0124C24.275 36.6499 22.1 36.0124 19.5 35.9374C18.575 35.9124 17.475 35.9374 17.0625 35.9999ZM22.1375 38.1624C23.3375 38.4749 24.9875 39.2249 25.9875 39.9124C26.2875 40.1124 26.9125 40.6499 27.3875 41.0874C31.375 44.8624 32.375 50.7374 29.825 55.5749C29.525 56.1249 29.075 56.8749 28.8 57.2249C28.3375 57.8499 28.3125 57.8749 28.2 57.5999C27.225 55.0749 25.825 53.3499 23.8625 52.1874C23.45 51.9499 23.075 51.7499 23.025 51.7499C22.975 51.7499 22.8625 51.6999 22.7625 51.6374C22.625 51.5499 22.7125 51.3999 23.1625 50.9249C26.125 47.8374 24.6125 42.6499 20.4375 41.5624C16.9125 40.6499 13.375 43.3999 13.375 47.0624C13.375 48.4624 13.925 49.8624 14.9 50.9374L15.45 51.5374L14.675 51.9374C12.5625 53.0374 10.9875 54.7999 10.125 57.0124L9.78749 57.8749L9.24999 57.1624C8.52499 56.1874 7.57499 54.1749 7.23749 52.8749C6.99999 51.9999 6.94999 51.4749 6.94999 49.9374C6.93749 48.2624 6.97499 47.9249 7.28749 46.8249C7.92499 44.5124 9.01249 42.7124 10.7875 41.0499C12.6375 39.3124 14.6375 38.3499 17.5 37.8249C17.675 37.7999 18.5125 37.7874 19.375 37.8124C20.5375 37.8374 21.2375 37.9249 22.1375 38.1624ZM20.25 43.4624C21.125 43.7374 22.125 44.6624 22.5125 45.5249C22.9125 46.4374 22.9125 47.6874 22.525 48.5624C22.1625 49.3499 21.4875 50.0499 20.6875 50.4749C19.8 50.9374 18.3375 50.9499 17.4375 50.4999C16.125 49.8624 15.25 48.4874 15.25 47.0749C15.25 44.4749 17.7625 42.6624 20.25 43.4624ZM20.6875 52.9374C22.1375 53.2374 23.2875 53.8874 24.4375 55.0499C25.55 56.1749 26.1 57.1124 26.4625 58.5374L26.6875 59.3874L26.25 59.7624C25.55 60.3499 23.1625 61.4624 21.9375 61.7749C20.35 62.1749 17.8 62.1749 16.1875 61.7749C14.9875 61.4749 12.9 60.5249 12.025 59.8749C11.4125 59.4124 11.375 59.1624 11.7375 58.1124C13.0625 54.2499 16.7625 52.1124 20.6875 52.9374Z" fill="black"/>
                        <path d="M39.4125 37.2497C37.9 37.4747 36.875 38.7497 36.875 40.4247C36.875 41.8622 37.7375 43.1622 38.875 43.4747C39.3125 43.5997 42.6125 43.6247 53.1375 43.5997L66.8375 43.5622L67.4375 43.1872C67.85 42.9247 68.15 42.5997 68.425 42.1247C68.775 41.5122 68.8125 41.3247 68.8125 40.4372C68.8125 39.5497 68.775 39.3622 68.425 38.7497C67.95 37.8997 67.225 37.4122 66.1875 37.2497C65.3 37.0997 40.4 37.1122 39.4125 37.2497ZM66.6375 39.4747C67.125 40.0247 67.15 40.8122 66.675 41.3622L66.35 41.7497H52.875H39.4125L39.0875 41.4247C38.275 40.6122 38.675 39.3372 39.8125 39.0872C39.95 39.0497 45.9625 39.0372 53.1625 39.0497L66.275 39.0622L66.6375 39.4747Z" fill="black"/>
                        <path d="M39.4875 46.7498C38.7125 46.8873 38.25 47.1373 37.725 47.7248C37.175 48.3373 36.95 48.9748 36.95 49.9373C36.95 50.9123 37.175 51.5373 37.7375 52.1623C38.6625 53.1998 37.4625 53.1248 52.9125 53.1248C67.8 53.1248 66.9875 53.1623 67.8625 52.4248C69.225 51.2748 69.2125 48.6248 67.8375 47.4123C67.2125 46.8623 66.6125 46.6998 65.175 46.6998C63.675 46.6873 63.375 46.8373 63.375 47.6248C63.375 48.3248 63.65 48.4998 64.7625 48.4998C66.0375 48.4998 66.5875 48.6748 66.875 49.1623C67.0125 49.3873 67.125 49.7248 67.125 49.9123C67.125 50.3498 66.825 50.9498 66.5125 51.1248C66.35 51.2123 61.825 51.2498 52.875 51.2498H39.475L39.1125 50.8873C38.3875 50.1623 38.725 48.9123 39.725 48.6248C40.025 48.5498 43.6875 48.4998 50.0875 48.4998H59.9875L60.175 48.2248C60.4375 47.8498 60.425 47.3373 60.1375 46.9873L59.9 46.6873L49.975 46.6748C44.525 46.6623 39.8 46.6998 39.4875 46.7498Z" fill="black" />
                        <path d="M39.475 56.25C37.9875 56.5 37 57.7875 37 59.4375C37 60.7625 37.625 61.8375 38.675 62.325C39.275 62.6 39.4625 62.625 41.525 62.625C43.6625 62.625 43.7375 62.6125 43.925 62.35C44.1875 61.975 44.175 61.4625 43.8875 61.1125C43.65 60.825 43.575 60.8125 41.6 60.775C39.6 60.7375 39.5625 60.725 39.225 60.4125C38.4875 59.7 38.7375 58.475 39.6875 58.15C40.0625 58.025 42.925 58 53.275 58.025L66.4 58.0625L66.7625 58.475C67.2375 59.0125 67.275 59.8125 66.825 60.3375L66.525 60.6875L57.025 60.75C47.9125 60.8125 47.5125 60.825 47.2625 61.05C46.925 61.3625 46.9 62.125 47.225 62.425C47.4375 62.6125 48.25 62.625 57.2125 62.6L66.9625 62.5625L67.5625 62.1875C69.55 60.95 69.425 57.625 67.35 56.5375L66.6875 56.1875L53.375 56.175C46.05 56.1625 39.8 56.2 39.475 56.25Z" fill="black" />
                    </g>
                    <defs>
                        <clipPath id="clip0_1193_3340">
                            <rect width="64" height="64" fill="white" transform="translate(5)" />
                        </clipPath>
                    </defs>
                    </svg>
                </span>
                <div class="flex flex-col lg:py-0 py-3 justify-center">
                    <span class="roboto-regular font-regular text-gray-12 text-xs md:text-base lg:text-base xl:text-lg dark:text-white leading-none lg:leading-5">{{ __('Your Reviews') }}</span>
                    <div class="dm-sans font-medium text-gray-12 text-2xl lg:text-34 dark:text-gray-2 leading-none lg:leading-10">{{ auth()->user()->totalReview() }}</div>
                </div>
            </a>
            <!-- Card -->
            <a href="{{ route('site.cart') }}" class="bg-gray-11 border border-gray-10 flex items-center rounded dark:bg-gray-800 py-5 2xl:py-7 {{ languageDirection() == 'ltr' ? '2xl:pl-11 lg:pl-4 md:pl-4 pl-4 pr-2' : '2xl:pr-11 lg:pr-4 md:pr-4 pr-4 pl-2' }}">
                <span  class="w-35p h-35p lg:w-16 lg:h-16 {{ languageDirection() == 'ltr' ? '2xl:mr-4 lg:mr-15p mr-2.5' : '2xl:ml-4 lg:ml-15p ml-2.5' }}">
                    <svg class="h-full w-full neg-transition-scale" xmlns="http://www.w3.org/2000/svg" width="64" height="64" viewBox="0 0 64 64" fill="none">
                    <rect x="41.8901" y="38.6992" width="19.2468" height="19.2468" rx="2" fill="#FCCA19" />
                    <rect y="7" width="37.3614" height="37.3614" rx="2" fill="#FCCA19" />
                    <g clip-path="url(#clip0_1193_3442)">
                        <path d="M27.175 0.225084C26.65 0.637584 26.625 0.850084 26.625 4.48758V8.00008H28H29.375V5.37508V2.75008H37.3125H45.25V4.00008V5.25008H42.5625C39.5625 5.25008 39.1625 5.32508 38.825 5.98758C38.65 6.31258 38.625 7.17508 38.625 12.5001V18.6251H31.3125H24V16.0001V13.3751H30H36V12.0001V10.6251H29.1875C23.2375 10.6251 22.3125 10.6501 21.9875 10.8251C21.3 11.1751 21.25 11.5126 21.25 15.2501V18.6251H17.75H14.2625L14.1125 18.0876C13 13.8751 11.9625 10.1626 11.75 9.58758C11.2125 8.16258 10.025 6.86258 8.52502 6.08758C7.18752 5.40008 6.65002 5.31258 3.52501 5.31258H0.725015L0.362515 5.72508C-0.149986 6.28758 -0.149986 7.11258 0.350015 7.62508L0.700015 7.96258L3.37501 8.02508C5.80002 8.08758 6.13752 8.11258 6.81252 8.37508C7.73752 8.73758 8.85002 9.80008 9.15002 10.6251C9.26252 10.9376 11.3875 18.7501 13.875 28.0001C16.35 37.2501 18.525 45.2626 18.7125 45.8126C19.4375 48.0501 20.9375 49.5626 23.25 50.4001L24.0625 50.6876L40.7875 50.7251C55.775 50.7501 57.55 50.7376 57.925 50.5626C58.4375 50.3126 58.6875 49.8751 58.675 49.2126C58.6625 48.8126 58.575 48.6251 58.2625 48.3501L57.875 48.0001H41.775C31.3625 48.0001 25.4125 47.9501 24.9 47.8751C24.4625 47.8001 23.85 47.6251 23.55 47.4751C22.8125 47.1376 21.9125 46.2501 21.6125 45.5626C21.475 45.2626 19.9625 39.8001 18.25 33.4251C16.525 27.0376 15.1 21.7251 15.05 21.6001C14.9875 21.3876 15.825 21.3751 37.75 21.4001L60.525 21.4376L60.8875 21.8501C61.0875 22.0751 61.25 22.3876 61.25 22.5626C61.25 22.8626 56.5875 36.6751 56.1375 37.6751C55.85 38.3376 55.075 39.1501 54.4 39.4876C54.125 39.6251 53.55 39.8001 53.1125 39.8751C52.6 39.9501 47.3 40.0001 38.1625 40.0001H24V41.3751V42.7626L38.9125 42.7126C54.875 42.6751 54.0625 42.7126 55.5125 42.0876C56.15 41.8126 57.375 40.8626 57.8125 40.3001C58.525 39.4001 58.75 38.8626 60.2625 34.4626C61.0875 32.0376 62.2625 28.6501 62.85 26.9376C63.925 23.8626 63.9375 23.8001 63.9375 22.6251C63.9375 21.5876 63.8875 21.3626 63.6 20.8001C63.2 20.0501 62.4375 19.3251 61.6375 18.9501C61.0625 18.6876 60.975 18.6876 51.225 18.6501L41.375 18.6251V13.3126V8.00008H46.6875H52V12.0001V16.0001H53.375H54.7625L54.725 11.0876C54.7 7.15008 54.65 6.13758 54.5125 5.92508C54.125 5.33758 53.9625 5.31258 50.9125 5.27508L48 5.23758V2.98758V0.725084L47.6375 0.362584L47.275 8.45546e-05H37.35C28.15 8.45546e-05 27.4125 0.0250845 27.175 0.225084Z" fill="#2C2C2C" />
                        <path d="M22.775 53.4375C19.85 54.075 18.05 57.1 18.825 60.0625C19.2125 61.575 20.2875 62.8625 21.725 63.5375C22.5125 63.9125 22.6375 63.9375 24 63.9375C25.3625 63.9375 25.4875 63.9125 26.275 63.5375C27.7125 62.8625 28.7875 61.575 29.175 60.0625C29.9625 57.075 28.1375 54.0625 25.175 53.4375C24.1375 53.2125 23.8 53.2125 22.775 53.4375ZM25.1125 56.3625C26.1125 56.875 26.7375 58.025 26.5625 58.9875C26.3125 60.325 25.275 61.25 24 61.25C22.725 61.25 21.6875 60.325 21.4375 58.9875C21.2625 58.0375 21.9375 56.8125 22.9125 56.325C23.475 56.05 24.525 56.075 25.1125 56.3625Z" fill="#2C2C2C" />
                        <path d="M52.35 53.375C51.05 53.6 49.8625 54.35 48.9875 55.5125C47.7625 57.125 47.65 59.6875 48.725 61.4375C49.7375 63.0875 51.3625 64 53.3125 64C55.4875 64 57.325 62.85 58.2 60.95C59.6875 57.7 57.6875 53.95 54.175 53.375C53.35 53.2375 53.1875 53.2375 52.35 53.375ZM54.4375 56.3625C56.225 57.175 56.375 59.7125 54.7125 60.825C53.75 61.4625 52.5125 61.35 51.6125 60.5375C50.2375 59.3 50.6 57.1125 52.3125 56.3125C52.8375 56.0625 53.85 56.0875 54.4375 56.3625Z" fill="#2C2C2C" />
                    </g>
                    <defs>
                        <clipPath id="clip0_1193_3442">
                            <rect width="64" height="64" fill="white" />
                        </clipPath>
                    </defs>
                </svg>
                </span>
                <div class="flex flex-col justify-center">
                    <p class="roboto-regular font-regular text-gray-12 text-xs md:text-base lg:text-base xl:text-lg dark:text-gray-2 leading-none lg:leading-5">
                        {{ __('Product in cart') }}
                    </p>
                    <div class="dm-sans font-medium text-gray-12 lg:text-34 text-2xl dark:text-gray-2 leading-none lg:leading-10">
                        {{ Cart::cartCollection()->count() }}
                    </div>
                </div>
            </a>
        </div>
        @if (count($orders) > 0)
            <a href="{{ route('site.order') }}" class="flex items-center justify-between lg:mb-4 mb-15p mt-16">
                <h2 class="dm-bold font-bold text-gray-12 text-lg xl:text-2xl uppercase dark:text-gray-2">{{ __('Last Orders') }}</h2>
                <div class="flex items-center text-gray-10 {{ languageDirection() == 'ltr' ? 'mr-4' : 'ml-4' }}">
                    <div class="dm-sans font-medium hidden md:block mt-2 {{ languageDirection() == 'ltr' ? 'mr-2' : 'ml-2' }}">
                        {{ __('See All') }}
                    </div>
                    <span class="arrow relative">
                        <svg class="absolute hover:text-gray-12 hidden md:block neg-transition-scale" xmlns="http://www.w3.org/2000/svg" width="15"
                            height="10" viewBox="0 0 15 10" fill="none">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M9.70696 0L8.29274 1.41421L10.5856 3.70711H0.999849C0.447564 3.70711 -0.000150681 4.15482 -0.000150681 4.70711C-0.000150681 5.25939 0.447564 5.70711 0.999849 5.70711H10.5856L8.29274 8L9.70696 9.41421L14.4141 4.70711L9.70696 0Z" fill="currentColor" />
                        </svg>
                    </span>
                </div>
            </a>
        @endif
        <div class="overflow-x-auto hidden md:block">
            <table class="w-full whitespace-no-wrap bg-white dark:bg-gray-2 overflow-hidden table-auto">
                <thead>
                    @if (count($orders) > 0)
                        <tr class="text-left bg-gray-11 border border-gray-2 dark:bg-gray-2 text-gray-500">
                            <th class="py-4 dm-sans font-medium text-gray-12 xl:text-xl md:text-base text-lg whitespace-nowrap dark:text-gray-2 {{ languageDirection() == 'ltr' ? 'pl-10 text-left' : 'pr-10 text-right' }}">{{ __('Invoice No') }}</th>
                            <th class="px-6 py-4 dm-sans font-medium text-gray-12 xl:text-xl md:text-base text-lg whitespace-nowrap dark:text-gray-2 {{ languageDirection() == 'ltr' ? 'text-left' : 'text-right' }}">{{ __('Order Date') }}</th>
                            <th class="px-6 py-4 dm-sans font-medium text-gray-12 xl:text-xl md:text-base text-lg whitespace-nowrap dark:text-gray-2 {{ languageDirection() == 'ltr' ? 'text-left' : 'text-right' }}">{{ __('Amount') }}</th>
                            <th class="px-25p py-4 dm-sans font-medium text-gray-12 xl:text-xl md:text-base text-lg whitespace-nowrap dark:text-gray-2 {{ languageDirection() == 'ltr' ? 'text-left' : 'text-right' }}">{{ __('Status') }}</th>
                            <th class="px-6 py-4 dm-sans font-medium text-gray-12 xl:text-xl md:text-base text-lg whitespace-nowrap dark:text-gray-2 {{ languageDirection() == 'ltr' ? 'text-left' : 'text-right' }}">{{ __('View') }}</th>
                        </tr>
                    @endif
                </thead>
                <tbody>
                    @if (count($orders) > 0)
                        @foreach ($orders as $order)
                            <tr class="focus-within:bg-gray-200 border border-gray-2 overflow-hidden">
                                <td class="dark:border-t-gray-2 dark:bg-gray-3 py-18p {{ languageDirection() == 'ltr' ? 'pl-10' : 'pr-10' }}">
                                    <a class="flex items-center" href="{{ route('site.orderDetails', $order->reference) }}">
                                         <span class="roboto-medium xl:text-base text-sm font-medium text-gray-10 flex items-center dark:text-gray-2">{{ $order->reference }}</span>
                                             <p class="{{ $order->payment_status == 'Paid' ? 'bg-green-5' : 'bg-orange-5' }} relative h-18p w-max justify-center text-white px-2 flex items-center rounded-sm {{ languageDirection() == 'ltr' ? 'ml-5' : 'mr-5' }} leading-3 roboto-medium font-medium text-xss whitespace-nowrap">{{ $order->payment_status == 'Paid' ? __('Paid') : __('Unpaid') }}</p>
                                     </a>
                                </td>
                                <td class="dark:border-t-gray-2 dark:bg-gray-3 {{ languageDirection() == 'ltr' ? 'pl-6' : 'pr-6' }}">
                                    <span class="roboto-medium xl:text-base text-sm font-medium text-gray-10 flex items-center whitespace-nowrap dark:text-gray-2">{{ formatDate($order->order_date) }}</span>
                                </td>
                                <td class="dark:border-t-gray-2 dark:bg-gray-3 {{ languageDirection() == 'ltr' ? 'pl-6' : 'pr-6' }}">
                                    <span class="roboto-medium font-medium text-gray-10 xl:text-base text-sm flex items-center whitespace-nowrap dark:text-gray-2">{{ optional($order->currency)->symbol . formatCurrencyAmount($order->total) }}</span>
                                </td>
                                <td class="dark:border-t-gray-2 {{ languageDirection() == 'ltr' ? 'pl-6' : 'pr-6' }}">
                                    <?php
                                        list($r, $g, $b) = sscanf($order->orderStatus->color, "#%02x%02x%02x");
                                    ?>
                                    <span class="roboto-medium font-medium text-base py-4 flex items-center dark:text-gray-2">
                                        <span class="h-8 w-32 py-2 text-center rounded text-xs" style="color: {{ $order->orderStatus->color }}; background: rgba({{ $r . ',' . $g . ',' . $b . ', 0.1' }});">
                                            {{ $order->orderStatus->name }}
                                        </span>
                                    </span>
                                </td>
                                <td class="dark:border-t-gray-2 dark:bg-gray-3 {{ languageDirection() == 'ltr' ? 'pl-6' : 'pr-6' }}">
                                    <div>
                                        <a href="{{ route('site.orderDetails', $order->reference) }}">
                                            <button class="px-1 py-1 rounded font-medium">
                                                <svg class="neg-transition-scale" xmlns="http://www.w3.org/2000/svg" width="18" height="20"
                                                    viewBox="0 0 18 20" fill="none">
                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M4 5C4 4.44772 4.44772 4 5 4L9 4C9.55228 4 10 4.44772 10 5C10 5.55229 9.55228 6 9 6L5 6C4.44772 6 4 5.55228 4 5Z" fill="#828282" />
                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M4 13C4 12.4477 4.44772 12 5 12L8 12C8.55228 12 9 12.4477 9 13C9 13.5523 8.55228 14 8 14L5 14C4.44772 14 4 13.5523 4 13Z" fill="#828282" />
                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M4 9C4 8.44772 4.44772 8 5 8L11 8C11.5523 8 12 8.44772 12 9C12 9.55229 11.5523 10 11 10L5 10C4.44772 10 4 9.55228 4 9Z" fill="#828282" />
                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M6.92943 20L8 20V18H7C5.55752 18 4.57625 17.9979 3.84143 17.8991C3.13538 17.8042 2.80836 17.6368 2.58579 17.4142C2.36322 17.1916 2.19585 16.8646 2.10092 16.1586C2.00213 15.4237 2 14.4425 2 13V7C2 5.55751 2.00213 4.57625 2.10092 3.84143C2.19585 3.13538 2.36322 2.80836 2.58579 2.58578C2.80836 2.36321 3.13538 2.19584 3.84143 2.10092C4.57625 2.00212 5.55752 2 7 2H9C10.4425 2 11.4238 2.00212 12.1586 2.10092C12.8646 2.19584 13.1916 2.36321 13.4142 2.58578C13.6368 2.80836 13.8042 3.13538 13.8991 3.84143C13.9979 4.57625 14 5.55751 14 7V9H16L16 6.92942C16 5.5753 16.0001 4.45869 15.8813 3.57493C15.7565 2.6471 15.4845 1.82768 14.8284 1.17157C14.1723 0.515463 13.3529 0.243494 12.4251 0.11875C11.5413 -6.86646e-05 10.4247 -3.8147e-05 9.07055 -1.90735e-06H6.92946C5.57533 -3.8147e-05 4.4587 -6.86646e-05 3.57494 0.11875C2.64711 0.243494 1.82768 0.515463 1.17158 1.17157C0.515467 1.82768 0.243498 2.6471 0.118755 3.57493C-6.35162e-05 4.45869 -3.41884e-05 5.57531 1.21679e-06 6.92943V13.0706C-3.41884e-05 14.4247 -6.35162e-05 15.5413 0.118755 16.4251C0.243498 17.3529 0.515467 18.1723 1.17158 18.8284C1.82768 19.4845 2.64711 19.7565 3.57494 19.8812C4.4587 20.0001 5.57531 20 6.92943 20Z" fill="#828282" />
                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M13.5 14C12.6716 14 12 14.6716 12 15.5C12 16.3284 12.6716 17 13.5 17C14.3284 17 15 16.3284 15 15.5C15 14.6716 14.3284 14 13.5 14ZM10 15.5C10 13.567 11.567 12 13.5 12C15.433 12 17 13.567 17 15.5C17 17.433 15.433 19 13.5 19C11.567 19 10 17.433 10 15.5Z" fill="#828282" />
                                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M14.7929 16.7929C15.1834 16.4024 15.8166 16.4024 16.2071 16.7929L17.7071 18.2929C18.0976 18.6834 18.0976 19.3166 17.7071 19.7071C17.3166 20.0976 16.6834 20.0976 16.2929 19.7071L14.7929 18.2071C14.4024 17.8166 14.4024 17.1834 14.7929 16.7929Z" fill="#828282" />
                                                </svg>
                                            </button>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    @endif
                </tbody>
            </table>
        </div>
        <div>
           @if (count($orders) > 0)
                @foreach ($orders as $order)
                    <div class="block md:hidden border border-gray-2 rounded">
                        <a href="{{ route('site.orderDetails', $order->reference) }}"
                            class="cursor-pointer flex justify-between p-15p border-t">
                            <div>
                                <p class="capitalized text-gray-10 text-xs roboto-medium font-medium mb-1.5">{{ __('Order number') }}</p>
                                <div class="flex items-center flex-wrap">
                                    <p class="roboto-medium text-xl font-medium text-gray-12 mb-1.5 {{ languageDirection() == 'ltr' ? 'mr-1' : 'ml-1' }}">
                                        {{ $order->reference }}</p>
                                        <p class="{{ $order->payment_status == 'Paid' ? 'bg-green-5' : 'bg-orange-5' }} relative h-18p w-max justify-center text-white px-2 flex items-center rounded-sm mb-1.5 leading-3 roboto-medium font-medium text-xss whitespace-nowrap">{{ $order->payment_status == 'Paid' ? __('Paid') : __('Unpaid') }}</p>
                                </div>
                                <p class="roboto-medium font-medium text-gray-10 text-xs">{{ formatDate($order->order_date) }}</p>
                            </div>
                            <div>
                                <?php
                                    list($r, $g, $b) = sscanf($order->orderStatus->color, "#%02x%02x%02x");
                                ?>
                                <p class="bg-gray-11 text-gray-10 px-4 w-max py-1.5 text-center rounded text-xs" style="color: {{ $order->orderStatus->color }}; background: rgba({{ $r . ',' . $g . ',' . $b . ', 0.1' }});">
                                    {{ optional($order->orderStatus)->name }}
                                </p>
                                <p class="roboto-medium font-medium text-gray-12 text-xl mt-1 dark:text-gray-2 {{ languageDirection() == 'ltr' ? 'mr-2 text-right' : 'ml-2 text-left' }}">{{ optional($order->currency)->symbol . formatCurrencyAmount($order->total) }}</p>
                            </div>
                        </a>
                    </div>
                @endforeach
                <div class="flex justify-center mb-4 mt-8">
                    <a href="{{ route('site.order') }}" class="flex relative lg:mt-2 arrow-hover md:hidden font-medium dm-sans text-gray-10 text-base {{ languageDirection() == 'ltr' ? 'pl-4' : 'pr-4' }} rounded-sm">
                <svg class="mt-2 absolute {{ languageDirection() == 'ltr' ? 'mr-3' : 'ml-3 neg-transition-scale' }}" width="15" height="10" viewBox="0 0 15 10" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd"
                        d="M4.70711 0L6.12132 1.41421L3.82843 3.70711H13.4142C13.9665 3.70711 14.4142 4.15482 14.4142 4.70711C14.4142 5.25939 13.9665 5.70711 13.4142 5.70711H3.82843L6.12132 8L4.70711 9.41421L0 4.70711L4.70711 0Z"
                        fill="currentColor" />
                </svg>
                <span class="{{ languageDirection() == 'ltr' ? 'ml-4' : 'mr-4' }} dm-sans font-medium">{{ __('See All') }}</span>
            </a>
                </div>
           @endif
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ asset('public/dist/js/custom/site/common.min.js') }}"></script>
@endsection
