<div class="px-4 md:px-8 py-2 h-74p md:sticky top-0 flex  {{ languageDirection() == 'ltr' ? 'md:justify-between' : 'justify-between' }} relative items-center shadow-sm bg-gray-12 dark:bg-red-2 z-50">
    <div class="flex flex-wrap items-center w-2/3 {{ languageDirection() == 'ltr' ? '' : 'md:order-1 order-2 justify-between md:justify-start' }}">
        <div class="p-2 rounded-full hover:bg-gray-200 cursor-pointer md:hidden {{ languageDirection() == 'ltr' ? '' : 'order-1' }}" @click="sidemenu = !sidemenu">
            <svg xmlns="http://www.w3.org/2000/svg" width="27" height="21" viewBox="0 0 27 21" fill="none">
                <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M0 18.5229C0 17.6559 0.737949 16.9531 1.64826 16.9531H11.5378C12.4481 16.9531 13.186 17.6559 13.186 18.5229C13.186 19.3899 12.4481 20.0927 11.5378 20.0927H1.64826C0.737949 20.0927 0 19.3899 0 18.5229Z"
                    fill="white" />
                <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M0 10.0468C0 9.00646 0.749663 8.16309 1.67442 8.16309H18.4186C19.3434 8.16309 20.093 9.00646 20.093 10.0468C20.093 11.0872 19.3434 11.9305 18.4186 11.9305H1.67442C0.749663 11.9305 0 11.0872 0 10.0468Z"
                    fill="white" />
                <path fill-rule="evenodd" clip-rule="evenodd"
                    d="M0 1.56977C0 0.702809 0.755519 0 1.6875 0H25.3125C26.2445 0 27 0.702809 27 1.56977C27 2.43673 26.2445 3.13953 25.3125 3.13953H1.6875C0.755519 3.13953 0 2.43673 0 1.56977Z" fill="white" />
            </svg>
        </div>
        @if ($headerMobileLogo->objectFile)
            <div class="md:hidden {{ languageDirection() == 'ltr' ? 'ml-3' : 'mr-auto' }}">
                <img class="w-36 h-11 object-contain neg-transition-scale" src="{{ $headerMobileLogo->fileUrl() }}" alt="{{ __('Image') }}">
            </div>
        @endif
        <div class="flex right-5 absolute md:relative flex-col justify-center cursor-pointer {{ languageDirection() == 'ltr' ? 'ml-2 md:ml-4 lg:ml-0 xl:ml-16' : 'mr-2 md:mr-4' }}">
            <a class="flex" href="{{ route('site.index') }}" target="_blank">
                <span>
                    <svg class=" {{ languageDirection() == 'ltr' ? '' : 'neg-transition-scale' }}" xmlns="http://www.w3.org/2000/svg" width="18" height="20" viewBox="0 0 18 20"
                        fill="none">
                        <path fill-rule="evenodd" clip-rule="evenodd"
                            d="M9.76378 0.251172C9.74165 0.254334 9.71944 0.257508 9.69716 0.260691L5.60205 0.845706C4.49632 1.00364 3.57928 1.13462 2.8568 1.33266C2.09566 1.5413 1.4357 1.85254 0.921633 2.44526C0.40757 3.03798 0.192799 3.73532 0.093895 4.51832C1.43051e-05 5.26155 3.8147e-05 6.18789 6.77109e-05 7.30485V12.6952C3.8147e-05 13.8121 1.43051e-05 14.7385 0.093895 15.4817C0.192799 16.2647 0.40757 16.962 0.921633 17.5547C1.4357 18.1475 2.09566 18.4587 2.8568 18.6673C3.57928 18.8654 4.49631 18.9964 5.60203 19.1543L9.76372 19.7488C10.7075 19.8837 11.5131 19.9988 12.1614 20C12.8516 20.0012 13.5304 19.8772 14.0994 19.3838C14.6683 18.8903 14.8871 18.2359 14.9835 17.5525C15.074 16.9105 15.074 16.0967 15.0739 15.1434L15.0739 14.7727H13.1897V15.0761C13.1897 16.1154 13.1875 16.7947 13.1177 17.2893C13.0517 17.7576 12.9456 17.8903 12.8648 17.9603C12.7841 18.0303 12.6377 18.1166 12.1648 18.1158C11.6653 18.1149 10.9925 18.021 9.96363 17.874L5.9287 17.2976C4.74742 17.1288 3.94915 17.013 3.35493 16.8501C2.7863 16.6943 2.52219 16.5244 2.34508 16.3202C2.16797 16.116 2.03716 15.8305 1.96327 15.2456C1.88605 14.6343 1.8843 13.8276 1.8843 12.6344V7.36563C1.8843 6.17236 1.88605 5.36574 1.96327 4.75445C2.03716 4.16949 2.16797 3.88401 2.34508 3.67981C2.52219 3.4756 2.7863 3.30573 3.35493 3.14985C3.94915 2.98697 4.74741 2.87116 5.92869 2.7024L9.96363 2.12598C10.9925 1.979 11.6653 1.88513 12.1648 1.88424C12.6377 1.88339 12.7841 1.96965 12.8648 2.03966C12.9456 2.10967 13.0517 2.24237 13.1177 2.71066C13.1875 3.20534 13.1897 3.88457 13.1897 4.92392V5.41372H15.0739V4.92392C15.0739 4.90141 15.0739 4.87898 15.0739 4.85663C15.074 3.90333 15.074 3.08951 14.9835 2.44754C14.8871 1.76412 14.6683 1.10967 14.0994 0.616213C13.5304 0.122757 12.8516 -0.0012301 12.1614 9.16871e-06C11.5131 0.00117325 10.7075 0.116306 9.76378 0.251172Z"
                            fill="white" />
                        <path fill-rule="evenodd" clip-rule="evenodd"
                            d="M8.6857 4.7002L10.157 5.87726L7.61309 9.05719H16.9583C17.4786 9.05719 17.9004 9.47899 17.9004 9.9993C17.9004 10.5196 17.4786 10.9414 16.9583 10.9414H7.61309L10.157 14.1213L8.6857 15.2984L4.44641 9.9993L8.6857 4.7002Z" fill="#FCCA19" />
                    </svg>
                </span>
                <span
                    class="dm-sans hidden lg:block font-medium whitespace-nowrap text-white {{ languageDirection() == 'ltr' ? 'ml-10p' : 'mr-10p' }}">{{ __('Visit Site') }}</span>
            </a>
        </div>
        @if (auth()->user()->role()->slug == 'super-admin')
            <div class="flex absolute md:right-5 right-32 md:relative flex-col justify-center cursor-pointer {{ languageDirection() == 'ltr' ? 'ml-2 md:ml-4 lg:ml-5 xl:ml-16 ' : 'mr-2 md:mr-4 lg:mr-5 xl:mr-16' }}">
                <a class="flex" href="{{ route('dashboard') }}" target="_blank">
                    <span>
                        <svg class="neg-transition-scale" width="19" height="19" viewBox="0 0 19 19" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                d="M19 0H10V2H15.5858L7.2929 10.2929C6.90237 10.6834 6.90237 11.3166 7.2929 11.7071C7.68342 12.0976 8.31658 12.0976 8.70711 11.7071L17 3.41421V9H19V0Z"
                                fill="#FCCA19" />
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                d="M3.90036 3.04616C4.39908 3.00096 5.04698 3 6 3C6.55229 3 7 2.55229 7 2C7 1.44772 6.55229 1 6 1L5.95396 1C5.05849 0.999985 4.31952 0.999972 3.71983 1.05432C3.09615 1.11085 2.52564 1.23242 2 1.5359C1.39192 1.88697 0.886973 2.39192 0.535898 3C0.232418 3.52564 0.11085 4.09615 0.0543234 4.71983C-2.83718e-05 5.31953 -1.50204e-05 6.05851 2.38419e-07 6.95399V12.0705C-3.60012e-05 13.4247 -6.65188e-05 14.5413 0.118752 15.4251C0.243496 16.3529 0.515463 17.1723 1.17157 17.8284C1.82768 18.4845 2.64711 18.7565 3.57494 18.8812C4.4587 19.0001 5.57532 19 6.92946 19H12.046C12.9415 19 13.6805 19 14.2802 18.9457C14.9039 18.8892 15.4744 18.7676 16 18.4641C16.6081 18.113 17.113 17.6081 17.4641 17C17.7676 16.4744 17.8891 15.9039 17.9457 15.2802C18 14.6805 18 13.9415 18 13.046L18 13C18 12.4477 17.5523 12 17 12C16.4477 12 16 12.4477 16 13C16 13.953 15.999 14.6009 15.9538 15.0996C15.9099 15.5846 15.8305 15.8295 15.732 16C15.5565 16.304 15.304 16.5565 15 16.732C14.8295 16.8305 14.5846 16.9099 14.0996 16.9538C13.6009 16.999 12.953 17 12 17H7C5.55752 17 4.57625 16.9979 3.84143 16.8991C3.13538 16.8042 2.80836 16.6368 2.58579 16.4142C2.36322 16.1916 2.19584 15.8646 2.10092 15.1586C2.00212 14.4237 2 13.4425 2 12V7C2 6.04698 2.00096 5.39908 2.04616 4.90036C2.09011 4.41539 2.16951 4.17051 2.26795 4C2.44349 3.69596 2.69596 3.44349 3 3.26795C3.17051 3.16951 3.41539 3.09011 3.90036 3.04616Z"
                                fill="white" />
                        </svg>
                    </span>
                    <span
                        class="dm-sans hidden lg:block font-medium whitespace-nowrap text-white {{ languageDirection() == 'ltr' ? 'ml-10p' : 'mr-10p' }}">{{ __('Admin Panel') }}</span>
                </a>
            </div>
        @endif
        @if (auth()->user()->role()->slug == 'super-admin' ||
            (auth()->user()->role()->slug == 'vendor-admin' &&
            optional(auth()->user()->vendors()->first())->status == 'Active'))
            <div
                class="flex md:right-5 right-24 absolute md:relative flex-col justify-center cursor-pointer {{ languageDirection() == 'ltr' ? 'ml-2 md:ml-4 lg:ml-5 xl:ml-16' : 'mr-2 md:mr-4 lg:mr-5 xl:mr-16' }}">
                <a class="flex" href="{{ route('vendor-dashboard') }}" target="_blank">
                    <span>
                        <svg class="neg-transition-scale" width="19" height="19" viewBox="0 0 19 19" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                d="M19 0H10V2H15.5858L7.2929 10.2929C6.90237 10.6834 6.90237 11.3166 7.2929 11.7071C7.68342 12.0976 8.31658 12.0976 8.70711 11.7071L17 3.41421V9H19V0Z"
                                fill="#FCCA19" />
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                d="M3.90036 3.04616C4.39908 3.00096 5.04698 3 6 3C6.55229 3 7 2.55229 7 2C7 1.44772 6.55229 1 6 1L5.95396 1C5.05849 0.999985 4.31952 0.999972 3.71983 1.05432C3.09615 1.11085 2.52564 1.23242 2 1.5359C1.39192 1.88697 0.886973 2.39192 0.535898 3C0.232418 3.52564 0.11085 4.09615 0.0543234 4.71983C-2.83718e-05 5.31953 -1.50204e-05 6.05851 2.38419e-07 6.95399V12.0705C-3.60012e-05 13.4247 -6.65188e-05 14.5413 0.118752 15.4251C0.243496 16.3529 0.515463 17.1723 1.17157 17.8284C1.82768 18.4845 2.64711 18.7565 3.57494 18.8812C4.4587 19.0001 5.57532 19 6.92946 19H12.046C12.9415 19 13.6805 19 14.2802 18.9457C14.9039 18.8892 15.4744 18.7676 16 18.4641C16.6081 18.113 17.113 17.6081 17.4641 17C17.7676 16.4744 17.8891 15.9039 17.9457 15.2802C18 14.6805 18 13.9415 18 13.046L18 13C18 12.4477 17.5523 12 17 12C16.4477 12 16 12.4477 16 13C16 13.953 15.999 14.6009 15.9538 15.0996C15.9099 15.5846 15.8305 15.8295 15.732 16C15.5565 16.304 15.304 16.5565 15 16.732C14.8295 16.8305 14.5846 16.9099 14.0996 16.9538C13.6009 16.999 12.953 17 12 17H7C5.55752 17 4.57625 16.9979 3.84143 16.8991C3.13538 16.8042 2.80836 16.6368 2.58579 16.4142C2.36322 16.1916 2.19584 15.8646 2.10092 15.1586C2.00212 14.4237 2 13.4425 2 12V7C2 6.04698 2.00096 5.39908 2.04616 4.90036C2.09011 4.41539 2.16951 4.17051 2.26795 4C2.44349 3.69596 2.69596 3.44349 3 3.26795C3.17051 3.16951 3.41539 3.09011 3.90036 3.04616Z" fill="white" />
                        </svg>
                    </span>
                    <span
                        class="dm-sans hidden lg:block font-medium whitespace-nowrap text-white {{ languageDirection() == 'ltr' ? 'ml-10p' : 'mr-10p' }}">{{ __('Vendor Panel') }}</span>
                </a>
            </div>
        @endif

        @includeIf('affiliate::layouts.includes.customer_panel_header')

        @impersonated
            <div class="flex flex-col justify-center cursor-pointer {{ languageDirection() == 'ltr' ? 'ml-11' : 'mr-11' }}">
                <a class="flex" href="{{ route('impersonator-cancel') }}">
                    <span>
                        <svg class="neg-transition-scale" xmlns="http://www.w3.org/2000/svg" width="18" height="20" viewBox="0 0 18 20"
                            fill="none">
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                d="M9.76378 0.251172C9.74165 0.254334 9.71944 0.257508 9.69716 0.260691L5.60205 0.845706C4.49632 1.00364 3.57928 1.13462 2.8568 1.33266C2.09566 1.5413 1.4357 1.85254 0.921633 2.44526C0.40757 3.03798 0.192799 3.73532 0.093895 4.51832C1.43051e-05 5.26155 3.8147e-05 6.18789 6.77109e-05 7.30485V12.6952C3.8147e-05 13.8121 1.43051e-05 14.7385 0.093895 15.4817C0.192799 16.2647 0.40757 16.962 0.921633 17.5547C1.4357 18.1475 2.09566 18.4587 2.8568 18.6673C3.57928 18.8654 4.49631 18.9964 5.60203 19.1543L9.76372 19.7488C10.7075 19.8837 11.5131 19.9988 12.1614 20C12.8516 20.0012 13.5304 19.8772 14.0994 19.3838C14.6683 18.8903 14.8871 18.2359 14.9835 17.5525C15.074 16.9105 15.074 16.0967 15.0739 15.1434L15.0739 14.7727H13.1897V15.0761C13.1897 16.1154 13.1875 16.7947 13.1177 17.2893C13.0517 17.7576 12.9456 17.8903 12.8648 17.9603C12.7841 18.0303 12.6377 18.1166 12.1648 18.1158C11.6653 18.1149 10.9925 18.021 9.96363 17.874L5.9287 17.2976C4.74742 17.1288 3.94915 17.013 3.35493 16.8501C2.7863 16.6943 2.52219 16.5244 2.34508 16.3202C2.16797 16.116 2.03716 15.8305 1.96327 15.2456C1.88605 14.6343 1.8843 13.8276 1.8843 12.6344V7.36563C1.8843 6.17236 1.88605 5.36574 1.96327 4.75445C2.03716 4.16949 2.16797 3.88401 2.34508 3.67981C2.52219 3.4756 2.7863 3.30573 3.35493 3.14985C3.94915 2.98697 4.74741 2.87116 5.92869 2.7024L9.96363 2.12598C10.9925 1.979 11.6653 1.88513 12.1648 1.88424C12.6377 1.88339 12.7841 1.96965 12.8648 2.03966C12.9456 2.10967 13.0517 2.24237 13.1177 2.71066C13.1875 3.20534 13.1897 3.88457 13.1897 4.92392V5.41372H15.0739V4.92392C15.0739 4.90141 15.0739 4.87898 15.0739 4.85663C15.074 3.90333 15.074 3.08951 14.9835 2.44754C14.8871 1.76412 14.6683 1.10967 14.0994 0.616213C13.5304 0.122757 12.8516 -0.0012301 12.1614 9.16871e-06C11.5131 0.00117325 10.7075 0.116306 9.76378 0.251172Z"
                                fill="white" />
                            <path fill-rule="evenodd" clip-rule="evenodd"
                                d="M8.6857 4.7002L10.157 5.87726L7.61309 9.05719H16.9583C17.4786 9.05719 17.9004 9.47899 17.9004 9.9993C17.9004 10.5196 17.4786 10.9414 16.9583 10.9414H7.61309L10.157 14.1213L8.6857 15.2984L4.44641 9.9993L8.6857 4.7002Z"
                                fill="#FCCA19" />
                        </svg>
                    </span>
                    <span class="dm-sans font-medium text-white {{ languageDirection() == 'ltr' ? 'ml-10p' : 'mr-10p' }}">{{ __('Go back to admin') }}</span>
                </a>
            </div>
        @endimpersonated
    </div>
    <div class="flex items-center {{ languageDirection() == 'ltr' ? '' : 'md:order-2 order-1' }}">
        <div class="relative hidden md:block" x-data="{ open: false }" x-cloak>
            <div @click="open = !open" class="flex items-center cursor-pointer {{ languageDirection() == 'ltr' ? '-ml-4' : '-mr-4' }}">
                <span class="{{ languageDirection() == 'ltr' ? 'mr-2.5' : 'ml-2.5' }}">
                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="15" viewBox="0 0 14 15"
                        fill="none">
                        <path fill-rule="evenodd" clip-rule="evenodd"
                            d="M6.99998 1.60409C5.6711 1.60409 4.59384 2.68136 4.59384 4.01023C4.59384 5.3391 5.6711 6.41637 6.99998 6.41637C8.32885 6.41637 9.40611 5.3391 9.40611 4.01023C9.40611 2.68136 8.32885 1.60409 6.99998 1.60409ZM2.98975 4.01023C2.98975 1.79544 4.78519 0 6.99998 0C9.21477 0 11.0102 1.79544 11.0102 4.01023C11.0102 6.22502 9.21477 8.02046 6.99998 8.02046C4.78519 8.02046 2.98975 6.22502 2.98975 4.01023Z"
                            fill="#ffffff" />
                        <path fill-rule="evenodd" clip-rule="evenodd"
                            d="M2.69391 10.7258C3.94726 10.0045 5.46049 9.62451 7 9.62451C8.53951 9.62451 10.0527 10.0045 11.3061 10.7258C12.559 11.4469 13.5116 12.488 13.953 13.7235C14.1021 14.1406 13.8847 14.5996 13.4676 14.7486C13.0504 14.8976 12.5915 14.6803 12.4424 14.2632C12.1527 13.4521 11.4943 12.6849 10.506 12.1161C9.51818 11.5477 8.28541 11.2286 7 11.2286C5.71459 11.2286 4.48183 11.5477 3.49402 12.1161C2.50575 12.6849 1.84731 13.4521 1.55756 14.2632C1.40853 14.6803 0.94956 14.8976 0.532425 14.7486C0.115289 14.5996 -0.102055 14.1406 0.0469736 13.7235C0.488366 12.488 1.44102 11.4469 2.69391 10.7258Z"
                            fill="#ffffff" />
                    </svg>
                </span>
                <span
                    class="text-white dm-sans text-base xl:text-sm overflow-hidden whitespace-nowrap font-medium {{ languageDirection() == 'ltr' ? 'mr-3' : 'ml-3' }}">
                    {{ auth()->user()->name }}
                </span>
                <span class="-mt-1">
                    <svg xmlns="http://www.w3.org/2000/svg" width="8" height="6" viewBox="0 0 8 6"
                        fill="none">
                        <path
                            d="M3.42633 5.921L0.164185 2.00642C-0.217154 1.54881 0.108249 0.854065 0.703921 0.854065L6.48608 0.854066C7.08175 0.854066 7.40715 1.54881 7.02581 2.00642L3.76367 5.921C3.67589 6.02633 3.51411 6.02633 3.42633 5.921Z"
                            fill="white" />
                    </svg>
                </span>
            </div>
            <div x-show.transition="open" @click.away="open = false"
                class="absolute mt-2 text-gray-10 bg-white border border-gray-2 shadow-md dark:border-gray-700 dark:text-gray-300 dark:bg-gray-700 z-40 {{ languageDirection() == 'ltr' ? 'right-0' : 'left-0' }}">
                <ul x-transition:leave="transition ease-in duration-150" x-transition:leave-start="opacity-100"
                    x-transition:leave-end="opacity-0" @click.away="closeProfileMenu"
                    @keydown.escape="closeProfileMenu"
                    class="absolute w-168 text-gray-10 bg-white border border-gray-100 rounded shadow-md dark:border-gray-700 dark:text-gray-300 dark:bg-gray-2 dark:border-gray-0 dark:text-gray-2 {{ languageDirection() == 'ltr' ? 'right-0' : 'left-0' }}"
                    aria-label="submenu">
                    <li class="flex text-gray-10">
                        <a href="{{ route('site.userProfile') }}"
                            class="inline-flex py-3.5 items-center w-full dm-sans font-medium text-sm transition-colors duration-150 hover:bg-gray-11 hover:text-gray-12 dark:hover:bg-gray-800 dark:hover:text-gray-200 dark:bg-hover dark:text-hover"
                            href="#">
                            <svg class="{{ languageDirection() == 'ltr' ? 'ml-3.5' : 'mr-3.5' }}" xmlns="http://www.w3.org/2000/svg" width="14" height="15"
                                viewBox="0 0 14 15" fill="none">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M6.99998 1.60409C5.6711 1.60409 4.59384 2.68136 4.59384 4.01023C4.59384 5.3391 5.6711 6.41637 6.99998 6.41637C8.32885 6.41637 9.40611 5.3391 9.40611 4.01023C9.40611 2.68136 8.32885 1.60409 6.99998 1.60409ZM2.98975 4.01023C2.98975 1.79544 4.78519 0 6.99998 0C9.21477 0 11.0102 1.79544 11.0102 4.01023C11.0102 6.22502 9.21477 8.02046 6.99998 8.02046C4.78519 8.02046 2.98975 6.22502 2.98975 4.01023Z"
                                    fill="currentColor" />
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M2.69391 10.7258C3.94726 10.0045 5.46049 9.62451 7 9.62451C8.53951 9.62451 10.0527 10.0045 11.3061 10.7258C12.559 11.4469 13.5116 12.488 13.953 13.7235C14.1021 14.1406 13.8847 14.5996 13.4676 14.7486C13.0504 14.8976 12.5915 14.6803 12.4424 14.2632C12.1527 13.4521 11.4943 12.6849 10.506 12.1161C9.51818 11.5477 8.28541 11.2286 7 11.2286C5.71459 11.2286 4.48183 11.5477 3.49402 12.1161C2.50575 12.6849 1.84731 13.4521 1.55756 14.2632C1.40853 14.6803 0.94956 14.8976 0.532425 14.7486C0.115289 14.5996 -0.102055 14.1406 0.0469736 13.7235C0.488366 12.488 1.44102 11.4469 2.69391 10.7258Z" fill="currentColor" />
                            </svg>
                            <span class="{{ languageDirection() == 'ltr' ? 'ml-2' : 'mr-2' }}">{{ __('My Profile') }}</span>
                        </a>
                    </li>
                    <li class="flex text-gray-10">
                        <a href="{{ route('site.userActivity') }}" class="inline-flex text-gray-10 py-3.5 items-center w-full dm-sans font-medium text-sm transition-colors duration-150 hover:bg-gray-11 hover:text-gray-12 dark:hover:bg-gray-800 dark:hover:text-gray-200 dark:bg-hover dark:text-hover">
                            <svg class="{{ languageDirection() == 'ltr' ? 'ml-3.5' : 'mr-3.5' }}" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-activity"><polyline points="22 12 18 12 15 21 9 3 6 12 2 12"></polyline></svg>
                            <span class="{{ languageDirection() == 'ltr' ? 'ml-2' : 'mr-2' }}">{{ __('Login Activities') }}</span>
                        </a>
                    </li>
                    <li class="flex text-gray-10">
                        <a href="{{ route('site.userSetting') }}"
                            class="inline-flex text-gray-10 py-3.5 items-center w-full dm-sans font-medium text-sm transition-colors duration-150  hover:bg-gray-11 hover:text-gray-12 dark:hover:bg-gray-800 dark:hover:text-gray-200 dark:bg-hover dark:text-hover">
                            <svg class="{{ languageDirection() == 'ltr' ? 'ml-3.5' : 'mr-3.5' }} neg-transition-scale" xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                viewBox="0 0 14 14" fill="currentColor">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M6.58176 1.12362e-06H7.41817C7.54287 -1.19244e-05 7.66554 -2.47447e-05 7.77055 0.00698867C7.88642 0.0147272 8.0224 0.0328607 8.16478 0.0891539C8.45118 0.202386 8.6868 0.415621 8.82796 0.689325C8.89815 0.825396 8.92972 0.958897 8.94895 1.07342C8.96638 1.17722 8.97857 1.29929 8.99097 1.42337L8.99257 1.43942C9.01976 1.71128 9.03686 1.87756 9.0581 1.99561C9.0597 2.00451 9.06125 2.01265 9.06274 2.02008C9.06904 2.01588 9.0759 2.01122 9.08333 2.00606C9.18182 1.93761 9.31149 1.83212 9.52295 1.65911L9.53542 1.64891C9.63192 1.56993 9.72686 1.49224 9.81258 1.43116C9.90716 1.36378 10.0239 1.29171 10.1697 1.24512C10.4631 1.1514 10.7805 1.16723 11.0631 1.28967C11.2035 1.35055 11.3125 1.43387 11.3999 1.51033C11.4791 1.57964 11.5659 1.66641 11.6541 1.7546L11.6654 1.76597L12.2454 2.34596C12.3336 2.43412 12.4204 2.52085 12.4896 2.60006C12.5661 2.68747 12.6494 2.79644 12.7103 2.93692C12.8328 3.21951 12.8486 3.53689 12.7549 3.83024C12.7083 3.97609 12.6362 4.09281 12.5688 4.18739C12.5077 4.27312 12.43 4.36807 12.3511 4.46458L12.3409 4.47704C12.1678 4.6885 12.0624 4.81817 11.9939 4.91667C11.9887 4.92409 11.9841 4.93095 11.9799 4.93725C11.9873 4.93874 11.9955 4.9403 12.0044 4.9419C12.1224 4.96314 12.2887 4.98024 12.5606 5.00743L12.5766 5.00903C12.7007 5.02143 12.8228 5.03362 12.9266 5.05105C13.0411 5.07028 13.1746 5.10186 13.3107 5.17204C13.5844 5.31321 13.7976 5.54882 13.9108 5.8352C13.9671 5.97758 13.9853 6.11357 13.993 6.22944C14 6.33446 14 6.45715 14 6.58185V7.41823C14 7.5429 14 7.66555 13.993 7.77054C13.9853 7.88638 13.9672 8.02233 13.9109 8.16468C13.7977 8.45115 13.5844 8.68684 13.3106 8.82801C13.1745 8.89817 13.0411 8.92973 12.9266 8.94895C12.8228 8.96638 12.7007 8.97857 12.5766 8.99097L12.5606 8.99257C12.2888 9.01974 12.1226 9.03684 12.0046 9.05807C11.9957 9.05968 11.9875 9.06123 11.9801 9.06272C11.9843 9.06902 11.989 9.07588 11.9941 9.0833C12.0626 9.18176 12.168 9.31138 12.341 9.52277L12.3512 9.53527C12.4301 9.63173 12.5078 9.72662 12.5688 9.8123C12.6362 9.90684 12.7082 10.0235 12.7548 10.1693C12.8486 10.4628 12.8328 10.7803 12.7103 11.063C12.6494 11.2034 12.5661 11.3123 12.4897 11.3997C12.4204 11.4789 12.3337 11.5656 12.2455 11.6537L11.6541 12.2451C11.5659 12.3333 11.4792 12.4201 11.3999 12.4894C11.3125 12.5658 11.2036 12.6492 11.0631 12.71C10.7805 12.8325 10.4631 12.8483 10.1698 12.7546C10.0239 12.708 9.90719 12.6359 9.81261 12.5686C9.7269 12.5075 9.63196 12.4298 9.53546 12.3508L9.52567 12.3428L9.52294 12.3406C9.31148 12.1676 9.18185 12.0621 9.08336 11.9937C9.07593 11.9885 9.06908 11.9838 9.06277 11.9796C9.06129 11.9871 9.05973 11.9952 9.05813 12.0041C9.03688 12.1222 9.01978 12.2885 8.99259 12.5604L8.99098 12.5765C8.97858 12.7006 8.96638 12.8227 8.94894 12.9266C8.92971 13.0411 8.89812 13.1747 8.82789 13.3108C8.68674 13.5844 8.45121 13.7976 8.16492 13.9108C8.02251 13.9671 7.88648 13.9853 7.77058 13.993C7.66553 14 7.5428 14 7.41806 14H6.58185C6.45715 14 6.33446 14 6.22944 13.993C6.11357 13.9853 5.97758 13.9671 5.8352 13.9108C5.54882 13.7976 5.31321 13.5844 5.17204 13.3107C5.10186 13.1746 5.07028 13.0411 5.05105 12.9266C5.03362 12.8228 5.02143 12.7007 5.00904 12.5766L5.00743 12.5606C4.98024 12.2887 4.96314 12.1224 4.9419 12.0044C4.9403 11.9955 4.93874 11.9873 4.93725 11.9799C4.93095 11.9841 4.92409 11.9888 4.91667 11.9939C4.81839 12.0622 4.68907 12.1674 4.47844 12.3397C4.47797 12.3401 4.47749 12.3405 4.47702 12.3409L4.46454 12.3511C4.36803 12.4301 4.27308 12.5078 4.18736 12.5688C4.09277 12.6362 3.97604 12.7083 3.83019 12.7549C3.53685 12.8486 3.21948 12.8328 2.93692 12.7103C2.79643 12.6495 2.68744 12.5661 2.60004 12.4897C2.52083 12.4204 2.4341 12.3336 2.34595 12.2455L1.76595 11.6655L1.75453 11.6541C1.66635 11.5659 1.5796 11.4792 1.5103 11.3999C1.43384 11.3125 1.35051 11.2036 1.28964 11.0631C1.1672 10.7805 1.15137 10.4631 1.24508 10.1698C1.29167 10.0239 1.36375 9.90719 1.43114 9.81261C1.49221 9.72689 1.56991 9.63194 1.6489 9.53543L1.65909 9.52296C1.83211 9.3115 1.9376 9.18183 2.00605 9.08333C2.01121 9.0759 2.01587 9.06905 2.02007 9.06274C2.01265 9.06125 2.0045 9.0597 1.9956 9.0581C1.87755 9.03685 1.71128 9.01976 1.43941 8.99257L1.42336 8.99096C1.29928 8.97857 1.17721 8.96638 1.07342 8.94895C0.958897 8.92972 0.825397 8.89814 0.689327 8.82796C0.41562 8.6868 0.202385 8.45117 0.0891532 8.16478C0.0328605 8.0224 0.014727 7.88642 0.00698859 7.77055C-2.47447e-05 7.66554 -1.19246e-05 7.54286 1.12343e-06 7.41817V6.58191C-1.19246e-05 6.45717 -2.48206e-05 6.33447 0.00699227 6.22943C0.0147349 6.11353 0.032878 5.97751 0.0891999 5.8351C0.202429 5.5488 0.415599 5.31325 0.689213 5.17209C0.825312 5.10188 0.958847 5.07029 1.0734 5.05106C1.17722 5.03362 1.29933 5.02142 1.42344 5.00903L1.43949 5.00742C1.43968 5.0074 1.4393 5.00744 1.43949 5.00742C1.71108 4.98026 1.87784 4.96311 1.99583 4.94187C2.00473 4.94027 2.01288 4.93872 2.0203 4.93723C2.0161 4.93092 2.01144 4.92406 2.00628 4.91663C1.9378 4.8181 1.83228 4.68839 1.65921 4.47685L1.64899 4.46437C1.56998 4.36782 1.49225 4.27284 1.43116 4.18709C1.36375 4.09247 1.29165 3.97569 1.24506 3.82978C1.15142 3.53653 1.16725 3.21928 1.2896 2.93681C1.35047 2.79626 1.43383 2.68724 1.51032 2.5998C1.57964 2.52055 1.66643 2.43378 1.75465 2.34558C1.75845 2.34178 1.76225 2.33798 1.76606 2.33417L2.33453 1.7657C2.33834 1.76189 2.34214 1.75809 2.34594 1.75429C2.43411 1.6661 2.52085 1.57934 2.60007 1.51004C2.68747 1.43358 2.79646 1.35025 2.93695 1.28937C3.21951 1.16694 3.53688 1.15111 3.83022 1.24482C3.97608 1.29141 4.09282 1.3635 4.18741 1.43089C4.27313 1.49197 4.36809 1.56967 4.46462 1.64866L4.4771 1.65888C4.68853 1.83187 4.81819 1.93735 4.91668 2.0058C4.92412 2.01097 4.93098 2.01564 4.93729 2.01984C4.93878 2.01241 4.94033 2.00427 4.94193 1.99537C4.96317 1.87735 4.98026 1.71112 5.00744 1.43933L5.00904 1.4233C5.02143 1.29925 5.03362 1.17721 5.05105 1.07344C5.07027 0.958948 5.10183 0.825484 5.17197 0.689444C5.31316 0.415645 5.54885 0.202341 5.83534 0.089105C5.97769 0.0328424 6.11363 0.014719 6.22947 0.0069848C6.33445 -2.47447e-05 6.45709 -1.19244e-05 6.58176 1.12362e-06ZM10.3289 11.3556L10.3262 11.3534L10.3108 11.3407C10.1232 11.1872 9.95436 11.0491 9.80969 10.9485C9.66545 10.8483 9.46711 10.7276 9.2227 10.6947C8.76952 10.6338 8.31846 10.8206 8.04111 11.1842C7.89153 11.3802 7.83663 11.6059 7.80552 11.7787C7.77431 11.9522 7.75261 12.1693 7.7285 12.4106L7.72617 12.4338C7.71153 12.5803 7.70331 12.6591 7.69379 12.7158C7.69339 12.7182 7.693 12.7205 7.69262 12.7226C7.69046 12.7228 7.68817 12.7229 7.68574 12.7231C7.6284 12.7269 7.54912 12.7273 7.40195 12.7273H6.59797C6.45084 12.7273 6.37158 12.7269 6.31426 12.7231C6.31183 12.723 6.30954 12.7228 6.30738 12.7226C6.307 12.7205 6.30661 12.7182 6.30621 12.7158C6.2967 12.6592 6.28848 12.5803 6.27384 12.4339L6.27152 12.4107C6.24741 12.1695 6.22571 11.9524 6.1945 11.7789C6.16339 11.6061 6.10848 11.3805 5.95889 11.1844C5.68155 10.8208 5.23052 10.634 4.77736 10.695C4.53294 10.7278 4.33458 10.8485 4.19033 10.9488C4.04564 11.0493 3.87678 11.1875 3.68917 11.341L3.67108 11.3558C3.66883 11.3577 3.66659 11.3595 3.66438 11.3613C3.55477 11.451 3.49472 11.4996 3.44886 11.5323C3.44688 11.5337 3.44499 11.535 3.44322 11.5363C3.44158 11.5349 3.43985 11.5334 3.43802 11.5317C3.39477 11.4939 3.3385 11.4381 3.23446 11.3341L2.6659 10.7655C2.56187 10.6615 2.50606 10.6052 2.46823 10.562C2.46663 10.5601 2.46512 10.5584 2.46371 10.5568C2.46495 10.555 2.46628 10.5531 2.46769 10.5511C2.50103 10.5043 2.55096 10.4428 2.64413 10.3289L2.65893 10.3108C2.81244 10.1232 2.95062 9.95435 3.05117 9.80967C3.15142 9.66542 3.27211 9.46708 3.30498 9.22267C3.36595 8.76949 3.17911 8.31843 2.81556 8.04109C2.61949 7.89151 2.3939 7.8366 2.22102 7.80549C2.0476 7.77429 1.8305 7.75259 1.58928 7.72848L1.56605 7.72616C1.41966 7.71152 1.34083 7.7033 1.28417 7.69379C1.28177 7.69339 1.27951 7.693 1.27738 7.69262C1.27721 7.69046 1.27705 7.68817 1.27689 7.68574C1.27306 7.62842 1.27273 7.54917 1.27273 7.40204V6.59804C1.27273 6.45087 1.27306 6.3716 1.27689 6.31426C1.27705 6.31183 1.27722 6.30954 1.27738 6.30738C1.27951 6.307 1.28177 6.30661 1.28417 6.30621C1.34079 6.2967 1.41954 6.28849 1.56572 6.27387C1.56558 6.27389 1.56585 6.27386 1.56572 6.27387L1.58936 6.27151C1.83064 6.2474 2.04781 6.22569 2.22127 6.19448C2.3942 6.16335 2.61984 6.10842 2.81595 5.95877C3.17935 5.68146 3.36613 5.23055 3.30525 4.77749C3.2724 4.53301 3.15168 4.3346 3.0514 4.19031C2.95082 4.04558 2.81261 3.87667 2.65904 3.689L2.64424 3.67092C2.55103 3.55699 2.50108 3.49542 2.46773 3.4486C2.46631 3.44662 2.46499 3.44474 2.46375 3.44297C2.46516 3.44132 2.46666 3.43959 2.46826 3.43776C2.5061 3.3945 2.56193 3.3382 2.66601 3.23413L3.23449 2.66565C3.33852 2.56161 3.3948 2.5058 3.43804 2.46797C3.43988 2.46637 3.44161 2.46486 3.44325 2.46345C3.44503 2.4647 3.44691 2.46602 3.4489 2.46744C3.4957 2.50078 3.55727 2.55073 3.67116 2.64391L3.68922 2.6587C3.87682 2.8122 4.04565 2.95036 4.19031 3.0509C4.33452 3.15112 4.53282 3.27181 4.77717 3.30471C5.23048 3.36576 5.68168 3.17887 5.95905 2.81516C6.10856 2.61912 6.16344 2.39359 6.19454 2.22076C6.22574 2.0474 6.24743 1.83035 6.27153 1.58921L6.27385 1.56597C6.28849 1.41962 6.2967 1.34081 6.30621 1.28417C6.30661 1.28177 6.307 1.2795 6.30738 1.27737C6.30953 1.27721 6.31182 1.27705 6.31425 1.27688C6.37156 1.27306 6.45079 1.27273 6.59788 1.27273H7.40204C7.54917 1.27273 7.62842 1.27306 7.68574 1.27689C7.68817 1.27705 7.69046 1.27721 7.69262 1.27738C7.693 1.27951 7.69339 1.28177 7.69379 1.28417C7.70331 1.34083 7.71152 1.41966 7.72616 1.56606L7.72848 1.58929C7.75259 1.8305 7.77429 2.04761 7.80549 2.22102C7.8366 2.3939 7.89151 2.61949 8.04109 2.81556C8.31843 3.17912 8.76949 3.36595 9.22268 3.30499C9.46708 3.27211 9.66542 3.15142 9.80967 3.05118C9.95435 2.95062 10.1232 2.81245 10.3108 2.65893L10.3289 2.64415C10.4428 2.55098 10.5043 2.50105 10.5511 2.46772C10.5531 2.4663 10.555 2.46498 10.5567 2.46374C10.5584 2.46515 10.5601 2.46665 10.5619 2.46826C10.6052 2.50608 10.6614 2.56189 10.7655 2.66592L11.3341 3.23449C11.4381 3.33853 11.4939 3.3948 11.5317 3.43804C11.5333 3.43988 11.5348 3.44161 11.5362 3.44325C11.535 3.44502 11.5337 3.4469 11.5323 3.44889C11.4989 3.49568 11.449 3.55723 11.3558 3.6711L11.341 3.68917C11.1875 3.87678 11.0493 4.04564 10.9488 4.19033C10.8485 4.33458 10.7278 4.53292 10.695 4.77734C10.634 5.23051 10.8208 5.68156 11.1844 5.9589C11.3805 6.10848 11.6061 6.16339 11.7789 6.1945C11.9524 6.22571 12.1695 6.24741 12.4107 6.27152L12.4339 6.27384C12.5803 6.28848 12.6592 6.29669 12.7158 6.30621C12.7182 6.30661 12.7205 6.307 12.7226 6.30738C12.7228 6.30954 12.723 6.31183 12.7231 6.31426C12.7269 6.37158 12.7273 6.45084 12.7273 6.59797V7.40211C12.7273 7.5492 12.7269 7.62844 12.7231 7.68575C12.723 7.68817 12.7228 7.69046 12.7226 7.69262C12.7205 7.693 12.7182 7.69339 12.7158 7.69379C12.6592 7.7033 12.5804 7.71152 12.434 7.72615L12.4108 7.72848C12.1696 7.75258 11.9526 7.77427 11.7792 7.80546C11.6064 7.83655 11.3809 7.89143 11.1848 8.04092C10.8211 8.3183 10.6342 8.76955 10.6952 9.22289C10.7282 9.46721 10.8488 9.66548 10.949 9.80967C11.0496 9.95431 11.1877 10.1231 11.3412 10.3107L11.3559 10.3287C11.4491 10.4425 11.499 10.5041 11.5323 10.5508C11.5337 10.5528 11.535 10.5547 11.5363 10.5565C11.5349 10.5581 11.5334 10.5598 11.5318 10.5617C11.4939 10.6049 11.4382 10.6612 11.3342 10.7651L10.7655 11.3338C10.6615 11.4378 10.6052 11.4936 10.562 11.5315C10.5601 11.5331 10.5584 11.5346 10.5568 11.536C10.555 11.5347 10.5531 11.5334 10.5511 11.532C10.5043 11.4987 10.4428 11.4487 10.3289 11.3556ZM7 5.09091C5.94564 5.09091 5.09091 5.94564 5.09091 7C5.09091 8.05436 5.94564 8.90909 7 8.90909C8.05436 8.90909 8.90909 8.05436 8.90909 7C8.90909 5.94564 8.05436 5.09091 7 5.09091ZM3.81818 7C3.81818 5.24273 5.24273 3.81818 7 3.81818C8.75727 3.81818 10.1818 5.24273 10.1818 7C10.1818 8.75727 8.75727 10.1818 7 10.1818C5.24273 10.1818 3.81818 8.75727 3.81818 7ZM2.04386 4.94699L2.30053 5.28335Z"
                                    fill="#currentColor" />
                            </svg>
                            <span class="{{ languageDirection() == 'ltr' ? 'ml-2' : 'mr-2' }}">{{ __('Account Settings') }}</span>
                        </a>
                    </li>
                    <li class="flex text-gray-10">
                        <a href="{{ route('site.logout') }}"
                            class="inline-flex text-gray-10 py-3.5 items-center w-full dm-sans font-medium text-sm transition-colors duration-150  hover:bg-gray-11 hover:text-gray-12 dark:hover:bg-gray-800 dark:hover:text-gray-200 dark:bg-hover dark:text-hover">
                            <svg class="{{ languageDirection() == 'ltr' ? 'ml-3.5' : 'mr-3.5' }} neg-transition-scale" xmlns="http://www.w3.org/2000/svg" width="14" height="14"
                                viewBox="0 0 14 14" fill="currentColor">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M10.8498 2.05007C11.1535 1.74633 11.646 1.74633 11.9497 2.05007C12.9287 3.02904 13.5954 4.27632 13.8655 5.63419C14.1356 6.99205 13.997 8.39952 13.4672 9.6786C12.9373 10.9577 12.0401 12.0509 10.889 12.8201C9.73785 13.5893 8.38447 13.9998 7 13.9998C5.61553 13.9998 4.26215 13.5893 3.11101 12.8201C1.95987 12.0509 1.06266 10.9577 0.532846 9.6786C0.00303309 8.39952 -0.13559 6.99205 0.134506 5.63419C0.404602 4.27632 1.07129 3.02904 2.05025 2.05007C2.354 1.74633 2.84646 1.74633 3.1502 2.05007C3.45394 2.35381 3.45394 2.84627 3.1502 3.15002C2.38878 3.91143 1.87025 4.88154 1.66017 5.93766C1.4501 6.99378 1.55791 8.08847 1.96999 9.08332C2.38207 10.0782 3.0799 10.9285 3.97523 11.5267C4.87056 12.1249 5.92319 12.4443 7 12.4443C8.07681 12.4443 9.12944 12.1249 10.0248 11.5267C10.9201 10.9285 11.6179 10.0782 12.03 9.08331C12.4421 8.08847 12.5499 6.99378 12.3398 5.93766C12.1298 4.88154 11.6112 3.91143 10.8498 3.15001C10.5461 2.84627 10.5461 2.35381 10.8498 2.05007Z"
                                    fill="#currentColor" />
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M6.99995 -3.39977e-08C7.4295 -5.27741e-08 7.77772 0.348223 7.77772 0.777777L7.77772 3.88889C7.77772 4.31844 7.4295 4.66666 6.99995 4.66666C6.57039 4.66666 6.22217 4.31844 6.22217 3.88889L6.22217 0.777777C6.22217 0.348223 6.57039 -1.52213e-08 6.99995 -3.39977e-08Z"
                                    fill="#currentColor" />
                            </svg>
                            <span class="{{ languageDirection() == 'ltr' ? 'ml-2' : 'mr-2' }}">{{ __('Sign Out') }}</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
@section('js')
    <script src="{{ asset('public/frontend/assets/js/notification-modal.min.js') }}"></script>
@endsection
