@extends('../site/layouts.user_panel.app')
@section('page_title', __('Order Details'))
@section('content')
    <div class="dark:bg-red-1 h-full xl:px-74p px-5 pt-30p xl:pt-14">
        <div class="flex justify-between">
            <div>
                <div class="flex items-center">
                    <span class="lg:mt-0 mt-1  {{ languageDirection() == 'ltr' ? 'mr-2' : 'ml-2' }}">
                        <svg class="h-30p w-10 xl:w-53p xl:h-11 neg-transition-scale" xmlns="http://www.w3.org/2000/svg" width="53" height="44" viewBox="0 0 53 44" fill="none">
                            <rect x="36.1779" y="27.377" width="16.6222" height="16.6222" rx="2" fill="#FCCA19" />
                            <rect width="32.2667" height="32.2667" rx="2" fill="#FCCA19" />
                        </svg>
                    </span>
                    <h1 class="dm-sans font-medium lg:pt-0 text-2xl xl:text-4xl text-gray-12 mb-1 dark:text-gray-2">
                        {{ __('Order Details') }}
                    </h1>
                </div>
                <p class="dark:text-gray-2 lg:mt-1.5 roboto-medium font-medium text-base xl:text-xl mt-2 text-20 text-gray-10 leading-6"> {{ __('Take a look at all the orders you made, their status and much more..') }}</p>
            </div>
            <div class="lg:block hidden">
                <a href="{{ route('site.order') }}" class="flex relative mt-2 arrow-hover font-medium dm-sans text-gray-10 text-base {{ languageDirection() == 'ltr' ? 'pl-4' : 'pr-4' }} rounded-sm">
                    <svg class="mt-2 absolute {{ languageDirection() == 'ltr' ? 'mr-3' : 'ml-3 neg-transition-scale' }}" width="15" height="10" viewBox="0 0 15 10" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path fill-rule="evenodd" clip-rule="evenodd" d="M4.70711 0L6.12132 1.41421L3.82843 3.70711H13.4142C13.9665 3.70711 14.4142 4.15482 14.4142 4.70711C14.4142 5.25939 13.9665 5.70711 13.4142 5.70711H3.82843L6.12132 8L4.70711 9.41421L0 4.70711L4.70711 0Z" fill="currentColor"/>
                    </svg>
                    <span class="dm-sans font-medium {{ languageDirection() == 'ltr' ? 'ml-4' : 'mr-4' }}">{{ __('Back') }}</span>
                </a>
            </div>
        </div>
        <div class="lg:mt-70p mt-8 xl:flex justify-between gap-30p">
            <div class="xl:w-1/5 w-full">
                <div class="flex flex-row xl:flex-col justify-between">
                    <div>
                        <p class="uppercase roboto-medium font-medium lg:text-lg text-15 text-gray-10">{{ __('Id Number') }}</p>
                        <h3 class="uppercase dm-bold font-bold text-gray-12 2xl:text-28 xl:text-2xl text-xl">{{ $order->reference }}</h3>
                        <a class="border border-black py-1 px-2 mt-2 inline-block" href="{{ route('site.invoice.print', ['id' => $order->id, 'type' => 'pdf']) }}">
                            <span class="pdf-inv-btn">{{ __('PDF') }} {{ __('Invoice') }}</span>
                        </a>
                    </div>
                    <div class="xl:mt-10">
                        <p class="uppercase roboto-medium font-medium xl:text-lg text-15 text-gray-10 {{ languageDirection() == 'ltr' ? 'lg:text-left text-right' : 'text-left lg:text-right' }}">{{ __('Status') }}</p>
                        <h3 class="uppercase dm-bold font-bold text-gray-12 2xl:text-28 xl:text-2xl text-xl {{ languageDirection() == 'ltr' ? 'xl:text-left text-right' : 'text-left xl:text-right' }}">{{ $order->orderStatus->name }}</h3>
                    </div>
                </div>
                @if(!is_null($order->shipping_title))
                    <div class="flex flex-row xl:flex-col justify-between">
                        <div class="mt-10">
                            <p class="uppercase roboto-medium font-medium xl:text-lg text-15 text-gray-10">{{ __('Shipping method') }}</p>
                            <h3 class="uppercase dm-bold font-bold text-gray-12 2xl:text-28 xl:text-2xl text-xl">
                                {{ $order->shipping_title }}
                            </h3>
                        </div>
                    </div>
                @endif
            </div>
            <div class="grid 2xl:grid-cols-3 xl:w-4/5 w-full lg:grid-cols-2 grid-cols-1 lg:gap-50p gap-5 mt-50p xl:mt-0">
                <div class="xl:pl-30p pl-5 pr-3 border border-gray-2 pb-6">
                    <div class="flex lg:mt-11 mt-6">
                        <span class="{{ languageDirection() == 'ltr' ? 'mr-4' : 'ml-4' }}">
                            <svg class="neg-transition-scale" xmlns="http://www.w3.org/2000/svg" width="54" height="38" viewBox="0 0 54 38" fill="none">
                                <rect x="23.3567" y="22.9004" width="10.7315" height="10.7315" rx="2" fill="#FCCA19"/>
                                <rect y="5.22559" width="20.8318" height="20.8318" rx="2" fill="#FCCA19"/>
                                <path d="M17.8648 0.0810509C16.9844 0.260738 16.1668 0.934566 15.8793 1.72519C15.7805 1.98574 15.2324 4.95058 14.6484 8.31973L13.5793 14.4561H11.7734H9.95859L9.41055 14.7346C8.82656 15.0221 8.52109 15.3275 8.19766 15.9295L8 16.2978V26.1357V35.9736L8.24258 36.4318C8.52109 36.9619 8.99727 37.4021 9.56328 37.6717L9.97656 37.8604H27.3613H44.7461L45.2582 37.6088C45.8332 37.3213 46.2555 36.89 46.534 36.2971C46.7137 35.9018 46.7227 35.7221 46.7496 32.3709L46.7766 28.858L47.2437 28.9389C48.0344 29.0916 49.0137 28.9928 49.4898 28.7143C50.0199 28.3998 50.4961 27.8338 50.6758 27.3127C50.7477 27.0881 51.5203 22.8115 52.3918 17.8252C53.6586 10.5389 53.9641 8.66113 53.9191 8.2748C53.7934 7.22363 53.0027 6.28926 52.0145 6.01972C51.691 5.92988 47.6121 5.20214 29.9219 2.04863C20.2637 0.332615 18.341 -0.00879288 18.2871 0.000190735C18.2602 0.00917816 18.0715 0.0451126 17.8648 0.0810509ZM35.0969 4.48339C46.2105 6.46894 51.7898 7.49316 51.9426 7.59199C52.2391 7.78965 52.4277 8.16699 52.4277 8.58926C52.4277 8.77793 52.3199 9.56855 52.1852 10.3412C51.9605 11.6709 51.9336 11.7518 51.7629 11.7158C51.6551 11.6889 48.5016 11.1228 44.7461 10.458C40.9906 9.78418 36.6871 9.02051 35.1777 8.75097C20.2906 6.0916 16.7148 5.45371 16.6879 5.42675C16.616 5.35488 17.218 2.27324 17.3438 2.08457C17.5234 1.80605 17.9996 1.51855 18.2691 1.51855C18.3859 1.51855 25.9598 2.84824 35.0969 4.48339ZM34.0098 10.0537C43.4703 11.7428 51.3227 13.1443 51.4484 13.1803L51.682 13.2432L50.532 19.8467C49.9031 23.4764 49.3371 26.6029 49.2832 26.7916C49.1125 27.3936 48.5555 27.5912 47.4684 27.4564L46.7676 27.3756V22.0568C46.7676 16.1541 46.7676 16.19 46.1836 15.4174C45.977 15.1479 45.6895 14.9232 45.3211 14.7346L44.7641 14.4561H29.9488C15.2684 14.4561 15.1426 14.4561 15.1426 14.2764C15.1426 14.1236 16.2207 7.86152 16.3645 7.15175C16.4094 6.94511 16.4543 6.90019 16.607 6.94511C16.7148 6.96308 24.5492 8.36465 34.0098 10.0537ZM44.5574 16.0193C44.7191 16.0822 44.9348 16.2529 45.0426 16.3877L45.2402 16.6393V26.1088C45.2402 34.8775 45.2313 35.6053 45.0875 35.8479C44.7461 36.4139 46.0309 36.3779 27.3164 36.3779C12.2676 36.3779 10.2551 36.36 10.0215 36.2432C9.45547 35.9467 9.48242 36.5037 9.48242 26.1178C9.48242 15.651 9.4375 16.4416 10.0574 16.0643C10.327 15.9025 10.7582 15.8936 27.2984 15.8936C41.5117 15.8936 44.3059 15.9115 44.5574 16.0193Z" fill="#2C2C2C"/>
                                <path d="M13.2558 23.8268C12.7886 23.9795 12.2316 24.5814 12.1058 25.0756C11.971 25.5967 11.9621 27.7709 12.0968 28.2291C12.2136 28.6693 12.6628 29.1725 13.121 29.3791C13.4445 29.5318 13.7769 29.5498 16.589 29.5498C19.6706 29.5498 19.6976 29.5498 20.0929 29.3432C20.3085 29.2264 20.614 28.9568 20.7578 28.7502L21.0273 28.3639L21.0542 26.8275C21.0722 25.8932 21.0453 25.1564 20.9913 24.9588C20.8656 24.5455 20.2097 23.9346 19.7605 23.8088C19.2843 23.674 13.6781 23.692 13.2558 23.8268ZM19.5269 25.3451C19.5988 25.417 19.6347 25.8303 19.6347 26.6209C19.6347 27.5732 19.6078 27.8158 19.482 27.9506C19.3472 28.1033 19.1406 28.1123 16.607 28.1123C14.891 28.1123 13.8038 28.0764 13.696 28.0225C13.5433 27.9326 13.5253 27.8158 13.5253 26.6389C13.5253 25.9381 13.5523 25.3271 13.5882 25.3002C13.6152 25.2643 14.9449 25.2373 16.5351 25.2373C18.6554 25.2373 19.446 25.2643 19.5269 25.3451Z" fill="#2C2C2C"/>
                                <path d="M12.5551 32.1822C12.2856 32.4697 12.2946 32.91 12.5821 33.1885L12.7977 33.4131H15.1606C17.7211 33.4131 17.8379 33.3951 18.0176 32.91C18.1165 32.6494 17.9727 32.1822 17.7481 32.0654C17.6493 32.0115 16.5711 31.9756 15.1606 31.9756C12.7528 31.9756 12.7438 31.9756 12.5551 32.1822Z" fill="#2C2C2C"/>
                                <path d="M20.632 32.2092C20.3804 32.5326 20.3894 32.9189 20.6679 33.1885L20.8835 33.4131H23.2734H25.6722L25.9417 33.1436C26.1663 32.91 26.2023 32.8201 26.1574 32.5775C26.0406 31.9846 25.9956 31.9756 23.2734 31.9756H20.8117L20.632 32.2092Z" fill="#2C2C2C"/>
                                <path d="M28.7179 32.2092C28.5023 32.4787 28.4843 32.7033 28.6371 32.9908C28.8527 33.3951 28.9066 33.4041 31.4312 33.4131H33.839L34.0546 33.1795C34.3242 32.883 34.3421 32.5236 34.0906 32.2092L33.9109 31.9756H31.4043H28.8976L28.7179 32.2092Z" fill="#2C2C2C"/>
                                <path d="M36.8937 32.1283C36.7949 32.2182 36.6781 32.4158 36.6512 32.5775C36.6062 32.8201 36.6422 32.91 36.8668 33.1436L37.1363 33.4131H39.5351H41.925L42.1406 33.1885C42.4371 32.901 42.4461 32.4428 42.1586 32.1732C41.9519 31.9846 41.889 31.9756 39.5172 31.9756C37.334 31.9756 37.0644 31.9936 36.8937 32.1283Z" fill="#2C2C2C"/>
                            </svg>
                        </span>

                        <h3 class="dm-sans font-medium text-lg text-gray-12">{{ __('Payment Information') }}</h3>
                    </div>
                    <div class="flex flex-wrap gap-2 items-center mt-11 lg:mb-38p mb-7">
                        <p class="roboto-medium font-medium text-gray-10 capitalize text-base">{{ __('status') }}:
                        </p>
                         <span class="{{ $order->payment_status == 'Paid' ? 'bg-green-2 text-green-1' : 'bg-pinks-2 text-reds-3' }}  px-3 text-lg w-max py-2 rounded-sm dm-sans font-medium {{ languageDirection() == 'ltr' ? 'ml-2 mr-1' : 'mr-2 ml-1' }}">{{$order->payment_status }}</span>
                            @if(optional($order->paymentMethod)->status == 'pending' && optional($order->orderStatus)->slug != 'cancelled' && optional($order->paymentMethod)->gateway != 'CashOnDelivery')
                            <a class="text-sm primary-bg-color px-30p py-3 rounded text-gray-12"href="{{ route('site.orderPayment.guest', ['reference' => $order->reference]) }}">{{ __('Pay Now') }}</a>
                            @endif
                    </div>
                    <div>
                        <P class="roboto-medium font-medium text-gray-10 mb-1.5 break-all">{{ __('Paid Amount') }}: {{ formatNumber($order->paid, optional($order->currency)->symbol) }}</P>
                        <p class="roboto-medium font-medium text-gray-10 mb-1.5 break-all">{{ __('Amount to be Paid') }}: {{ formatNumber($order->total - $order->paid, optional($order->currency)->symbol) }}</p>
                        @if(preference("taxes") == 1)
                        <p class="uppercase roboto-medium break-all font-medium text-gray-10">{{ __('Tax') }}:
                            <span>{{ formatNumber($order->tax_charge, optional($order->currency)->symbol) }}</span>
                        </p>
                        @endif
                    </div>
                    <p class="dm-sans break-all font-medium text-gray-12 lg:mt-8 mt-5">{{ __('Payment Method') }}: {{ !empty($order->paymentMethod->gateway) ? paymentRenamed($order->paymentMethod->gateway) : __('Unknown') }}</p>
                </div>

                @php
                    $shippingAddress = $order->getShippingAddress();
                    $billingAddress = $order->getBillingAddress();
                @endphp
                <div class="xl:px-30p px-5 border border-gray-2 pb-6">
                    <div class="flex mt-11">
                        <span class="{{ languageDirection() == 'ltr' ? 'mr-4' : 'ml-4' }}">
                            <svg class="neg-transition-scale" xmlns="http://www.w3.org/2000/svg" width="56" height="41" viewBox="0 0 56 41" fill="none">
                                <rect x="23.3569" y="17.9004" width="10.7315" height="10.7315" rx="2" fill="#FCCA19"/>
                                <rect y="0.225586" width="20.8318" height="20.8318" rx="2" fill="#FCCA19"/>
                                <path d="M13.1786 2.07299C12.8971 2.1877 12.7928 2.68824 12.5425 5.38904L12.2714 8.20455L7.34947 8.23583L2.42754 8.25668L2.21898 8.52781C2.09385 8.68422 2 8.87193 2 8.94492C2 9.24733 2.2607 9.6123 2.55267 9.71658C2.7508 9.77914 4.53396 9.82086 7.49545 9.82086H12.1254L12.0733 10.2588C12.0316 10.5091 11.823 12.6781 11.5936 15.0869C11.3642 17.4957 11.1556 19.5291 11.1243 19.5917C11.093 19.696 10.6864 19.7273 9.59144 19.7273C7.83957 19.7273 7.63102 19.8003 7.63102 20.4468C7.63102 21.1455 7.83957 21.2289 9.51845 21.2706C10.6238 21.3019 10.9679 21.3436 10.9679 21.4479C10.9679 21.5209 10.6864 24.4824 10.3422 28.0174C9.99813 31.5524 9.71658 34.6495 9.71658 34.8997C9.71658 35.1813 9.78957 35.4316 9.91471 35.588C10.1128 35.8278 10.165 35.8382 12.042 35.8695L13.9607 35.9008L14.0858 36.4743C14.2631 37.3711 14.8783 38.4556 15.6604 39.2273C17.9128 41.4693 21.3749 41.5735 23.7733 39.4775C24.6805 38.685 25.4521 37.3711 25.619 36.3283L25.692 35.8904H31.9904H38.2888L38.3513 36.1719C38.7476 37.9968 39.9259 39.561 41.4797 40.3535C42.1888 40.7184 43.388 41 44.1805 41C44.973 41 46.1722 40.7184 46.8813 40.3535C48.4037 39.5818 49.6134 37.9655 50.0096 36.1824L50.0722 35.8904H51.7824C53.5968 35.8904 54.0452 35.807 54.2225 35.442C54.3997 35.0874 55.2131 27.8193 55.3487 25.3479C55.4217 23.9401 55.3278 23.0329 54.9524 21.7607C54.0035 18.4759 51.3965 15.8898 48.0179 14.8575C47.1628 14.5968 46.923 14.5759 44.4933 14.5238L41.8864 14.4612L41.9176 14.0441C41.9281 13.8147 42.1471 11.1973 42.4078 8.21497C42.6684 5.24305 42.877 2.74037 42.877 2.65695C42.877 2.58396 42.7623 2.39626 42.6163 2.2607L42.366 2H34.0864C25.911 2 25.8171 2 25.5877 2.20856C25.254 2.52139 25.2749 3.06364 25.6294 3.34519C25.9005 3.56417 25.9735 3.56417 33.5545 3.56417C40.7706 3.56417 41.2086 3.5746 41.2086 3.74144C41.2086 4.10642 39.3211 25.7233 39.2794 25.8484C39.2481 25.9527 36.4222 25.984 25.6607 25.984H12.0941L12.1463 25.5356C12.188 25.2957 12.2922 24.2425 12.3861 23.1997L12.5634 21.3019L15.3059 21.2706C17.819 21.2393 18.0588 21.2184 18.257 21.0412C18.4029 20.9056 18.4759 20.7179 18.4759 20.4468C18.4759 19.7481 18.3821 19.7273 15.3789 19.7273C13.4289 19.7273 12.7406 19.696 12.7406 19.6021C12.7406 19.4249 13.5644 10.8949 13.6374 10.3214L13.7 9.83128L17.9545 9.8C21.9693 9.76872 22.2195 9.75829 22.4281 9.57059C22.7096 9.30989 22.7201 8.74679 22.4385 8.46524C22.2404 8.26711 22.0944 8.25668 18.0588 8.25668H13.8877V7.93342C13.8877 7.54759 14.1797 4.3984 14.2631 3.89786L14.3152 3.56417H18.7262C23.0329 3.56417 23.1476 3.56417 23.4187 3.34519C23.7733 3.06364 23.7941 2.52139 23.4604 2.20856C23.2414 2 23.1267 2 18.2778 2.01043C15.5457 2.01043 13.2516 2.04171 13.1786 2.07299ZM44.7332 18.2882C44.6289 19.5083 44.5246 20.5719 44.4933 20.6345C44.462 20.7388 44.0449 20.7701 42.877 20.7701C42.0219 20.7701 41.3128 20.7492 41.3128 20.7179C41.3128 20.5928 41.6257 17.1099 41.6778 16.6198L41.7404 16.0775H43.3254H44.9104L44.7332 18.2882ZM48.0283 16.5051C50.5623 17.3497 52.7521 19.6856 53.5134 22.3342C53.7636 23.1997 53.9305 25.692 53.7532 25.8067C53.7011 25.838 53.3987 25.7545 53.0858 25.6086C52.6479 25.4 52.1473 24.962 50.8021 23.596C49.2797 22.0422 48.9877 21.8024 48.2995 21.4583C47.8719 21.2602 47.215 21.0099 46.8396 20.916C46.4642 20.8222 46.1409 20.7283 46.1305 20.7179C46.0783 20.6762 46.4225 16.5051 46.485 16.2965C46.5372 16.1193 47.1003 16.1922 48.0283 16.5051ZM46.8083 22.5219C47.7676 22.8243 48.2473 23.1893 50.0201 24.9933C51.4487 26.4428 51.7928 26.7348 52.3767 27.0163C52.7626 27.1936 53.1693 27.3396 53.2944 27.3396C53.4195 27.3396 53.5447 27.4021 53.5759 27.4751C53.6385 27.642 52.9294 34.0655 52.8356 34.2219C52.7939 34.2845 52.1995 34.3262 51.4278 34.3262H50.093L49.9158 33.6171C49.457 31.6984 47.8406 29.9882 45.9636 29.3939C44.9313 29.0706 43.4297 29.0706 42.3973 29.3939C40.5203 29.9882 38.904 31.6984 38.4452 33.6171L38.2679 34.3262L32.0008 34.3053L25.7233 34.2741L25.5981 33.711C25.0246 31.104 22.5219 29.1123 19.8316 29.1123C17.162 29.1123 14.6385 31.1249 14.065 33.711L13.9398 34.2741H12.6364C11.5414 34.2741 11.3329 34.2532 11.3433 34.1176C11.3433 34.0342 11.4893 32.5222 11.6561 30.7495L11.9586 27.5481H25.9422C35.8799 27.5481 40.0198 27.5168 40.2596 27.4334C40.4369 27.3709 40.6246 27.2353 40.6767 27.1414C40.7289 27.0476 40.854 26.0361 40.9479 24.889C41.0417 23.742 41.1356 22.6992 41.1668 22.5636L41.2086 22.3342H43.7008C45.8176 22.3342 46.2869 22.3655 46.8083 22.5219ZM21.3644 30.9684C23.4187 31.7505 24.6075 33.9925 24.0652 36.0989C23.2206 39.4045 19.1642 40.5307 16.7553 38.1324C13.9398 35.3168 16.0671 30.5096 20.0401 30.7182C20.4676 30.739 21.062 30.8537 21.3644 30.9684ZM45.2024 30.8329C47.2254 31.3543 48.5289 33.0123 48.5289 35.0561C48.5289 36.2971 48.1848 37.1417 47.3193 38.0594C45.5987 39.8738 42.7623 39.8738 41.0417 38.0594C40.1762 37.1417 39.8321 36.2971 39.8321 35.0561C39.8321 33.8048 40.2909 32.7412 41.1981 31.8965C42.3139 30.8537 43.7842 30.4575 45.2024 30.8329Z" fill="#2C2C2C"/>
                                <path d="M18.6846 32.46C17.6314 32.9293 17.0161 33.8991 17.0161 35.0566C17.0265 36.6833 18.2153 37.8721 19.8316 37.8721C21.4479 37.8721 22.6367 36.6833 22.6471 35.0566C22.6471 33.4403 21.4584 32.2411 19.8316 32.2411C19.3728 32.2411 18.9974 32.314 18.6846 32.46ZM20.718 34.1702C21.0412 34.4935 21.083 34.6082 21.083 35.0566C21.083 35.505 21.0412 35.6197 20.718 35.9429C20.3947 36.2662 20.28 36.3079 19.8316 36.3079C19.3832 36.3079 19.2685 36.2662 18.9453 35.9429C18.622 35.6197 18.5803 35.505 18.5803 35.0566C18.5803 34.6082 18.622 34.4935 18.9453 34.1702C19.2685 33.8469 19.3832 33.8052 19.8316 33.8052C20.28 33.8052 20.3947 33.8469 20.718 34.1702Z" fill="#2C2C2C"/>
                                <path d="M43.169 32.3864C42.585 32.5949 42.0115 33.1059 41.6674 33.7211C41.4067 34.1904 41.365 34.3885 41.365 35.0559C41.365 35.7233 41.4067 35.9214 41.6674 36.3907C42.2096 37.3709 43.0752 37.8818 44.1805 37.8818C45.2858 37.8818 46.1514 37.3709 46.6936 36.3907C46.9543 35.9214 46.996 35.7233 46.996 35.0559C46.996 34.3885 46.9543 34.1904 46.6936 33.7211C46.1409 32.7409 45.3171 32.2508 44.1805 32.2508C43.8364 32.2508 43.3776 32.3134 43.169 32.3864ZM44.8687 33.9818C45.192 34.1695 45.484 34.6805 45.484 35.0559C45.484 35.4313 45.192 35.9423 44.8479 36.1404C44.2014 36.5158 43.3463 36.276 43.0334 35.619C42.8353 35.2019 42.8353 34.9099 43.0334 34.4928C43.3358 33.8463 44.2222 33.6064 44.8687 33.9818Z"  fill="#2C2C2C"/>
                                <path d="M5.02399 14.7431C4.58602 15.2227 4.86757 15.9005 5.57666 16.0257C5.77479 16.0674 6.77586 16.0778 7.80821 16.057C9.9772 16.0257 10.1336 15.9631 10.1336 15.2332C10.1336 14.5449 9.99805 14.5136 7.45367 14.5136C5.31597 14.5136 5.23254 14.5241 5.02399 14.7431Z" fill="#2C2C2C"/>
                            </svg>
                        </span>
                        <h3 class="dm-sans font-medium text-lg text-gray-12">{{ __('Shipping Address') }}</h3>
                    </div>
                    <div class="mt-8">
                        <p class="roboto-medium font-medium text-gray-10 mb-1.5 break-all">{{ $shippingAddress->first_name . ' ' . $shippingAddress->last_name }}</p>
                        <p class="roboto-medium font-medium text-gray-10 mb-1.5 break-all"> {{ $shippingAddress->address_1 }}
                            {{ !empty($shippingAddress->address_2) ? ', ' . $shippingAddress->address_2 . ',' : '' }}
                            {{ $shippingAddress->city }}</p>
                        <p class="roboto-medium font-medium text-gray-10 mb-1.5 break-all">{{ __('Postcode') }}: {{ $shippingAddress->zip }}</p>
                        <p class="roboto-medium font-medium text-gray-10 mb-1.5 break-all">{{ __('State') }}: {{ $shippingAddress->state }}</p>
                        <p class="roboto-medium font-medium text-gray-10 mb-1.5 break-all">{{ __('Country') }}:{{ $shippingAddress->country }}</p>
                    </div>
                    @if(!empty($order->note))
                    <div>
                        <p class="mt-30p dm-sans font-medium text-gray-12">{{ __('Delivery Instructions') }}:</p>
                        <p class="mt-2 roboto-medium font-medium text-gray-10 text-sm break-all {{ languageDirection() == 'ltr' ? 'pr-5' : 'pl-5' }}">{{ $order->note }}</p>
                    </div>
                    @endif
                </div>
                <div class="xl:px-30p px-5 border border-gray-2 pb-6">
                    <div class="flex mt-11">
                        <span class="{{ languageDirection() == 'ltr' ? 'mr-4' : 'ml-4' }}">
                            <svg class="neg-transition-scale" xmlns="http://www.w3.org/2000/svg" width="47" height="40" viewBox="0 0 47 40" fill="none">
                                <rect x="23.3569" y="17.6748" width="10.7315" height="10.7315" rx="2" fill="#FCCA19"/>
                                <rect width="20.8318" height="20.8318" rx="2" fill="#FCCA19"/>
                                <path d="M36.1437 0.104565C34.0932 0.375237 32.0262 1.40871 30.5334 2.89331C29.7542 3.68072 28.8356 5.00947 28.4993 5.8461L28.2696 6.41204H19.7229H11.1762L10.9466 6.6089L10.7169 6.80575L10.6677 11.5138C10.6349 14.0975 10.6103 18.297 10.6021 20.8479C10.6021 23.3988 10.5693 26.7289 10.5365 28.2463L10.4873 31.0186H7.95279H5.41831L5.21326 31.2237L5 31.4369L5.03281 33.5449C5.06562 35.456 5.08202 35.7021 5.25427 36.227C5.70539 37.6296 6.68965 38.7779 7.9856 39.4094C8.40391 39.6145 8.98626 39.836 9.28154 39.8934C9.70806 39.9754 12.1359 40 21.0517 40C31.7063 40 32.3133 39.9918 32.8218 39.8524C34.331 39.4258 35.5531 38.4252 36.2257 37.0718C36.8573 35.7841 36.8409 36.0712 36.8409 27.1964V19.3715H37.4396C39.9167 19.3633 42.32 18.338 44.149 16.5089C46.1422 14.524 47.1264 11.9649 46.987 9.20079C46.7491 4.78801 43.5831 1.12164 39.2277 0.219395C38.4649 0.0635529 36.8901 -0.00206375 36.1437 0.104565ZM38.7356 1.53995C42.2543 2.13871 44.9693 4.88644 45.5352 8.40518C45.6992 9.38944 45.6008 11.0299 45.3384 11.9485C44.5591 14.5896 42.5988 16.6648 40.0561 17.5342C38.9735 17.9033 38.2353 18.0017 36.9639 17.9525C35.6844 17.9033 34.9298 17.7229 33.8307 17.1979C31.5177 16.107 29.91 14.1221 29.2785 11.604C29.0324 10.6362 29.016 8.89731 29.2457 7.92945C29.7788 5.62463 31.1814 3.70532 33.1909 2.54061C34.8888 1.56455 36.8163 1.21186 38.7356 1.53995ZM27.8021 8.23293C27.5806 9.55348 27.7939 11.6778 28.2696 12.9492C28.3844 13.2445 28.4747 13.4987 28.4747 13.5151C28.4747 13.5315 27.0147 13.5479 25.2266 13.5479C21.9129 13.5479 21.7653 13.5644 21.5274 13.8678C21.3962 14.0401 21.3962 14.4502 21.5274 14.6224C21.7653 14.9341 21.8965 14.9423 25.6285 14.9423H29.2703L29.5902 15.4098C30.0413 16.0742 31.1076 17.1159 31.8622 17.6326C32.6578 18.1822 33.8061 18.7317 34.7083 18.986L35.4055 19.1911L35.4301 27.1308C35.4383 32.6098 35.4219 35.2099 35.3563 35.5134C35.2169 36.2106 34.7657 37.0062 34.2326 37.5147C32.141 39.5161 28.7945 38.7451 27.7201 36.0301C27.556 35.6118 27.5396 35.3822 27.4986 33.4547C27.4494 31.3467 27.4494 31.3303 27.2525 31.1744C27.0721 31.0268 26.8178 31.0186 19.4769 31.0186H11.8898L11.9391 21.8076C11.9637 16.7468 12.0129 11.522 12.0375 10.2015L12.0867 7.80642H19.9854H27.8759L27.8021 8.23293ZM26.1206 33.9878C26.1616 35.7923 26.2191 36.1122 26.6866 37.0472C26.9573 37.5804 27.392 38.1709 27.7283 38.458L27.9415 38.6466H18.9191C11.1762 38.6466 9.82289 38.6302 9.42098 38.5236C8.07582 38.1709 7.01774 37.1867 6.58302 35.8825C6.43538 35.4396 6.41078 35.1689 6.41078 33.8484V32.331H16.2452H26.0796L26.1206 33.9878Z" fill="#2C2C2C"/>
                                <path d="M36.7998 3.58238C36.6357 3.74643 36.5947 3.86126 36.5947 4.22215V4.66507L36.0698 4.92754C35.4792 5.21462 34.9871 5.71495 34.6918 6.31371C34.536 6.6418 34.5032 6.83045 34.5032 7.51943C34.5032 8.25763 34.5278 8.38066 34.7328 8.77437C35.2168 9.70122 35.996 10.218 37.1033 10.3574C37.8415 10.4476 38.0875 10.5542 38.4156 10.8987C39.3014 11.8338 38.6371 13.384 37.3329 13.4004C36.5373 13.4004 35.9139 12.8509 35.8073 12.047C35.7335 11.5303 35.4874 11.2514 35.0937 11.2514C34.6754 11.2514 34.4622 11.5221 34.4622 12.0552C34.4622 13.0149 35.1757 14.0812 36.1108 14.5077L36.5947 14.7292V15.2295C36.5947 15.6478 36.6275 15.7626 36.7834 15.9103C37.0458 16.1563 37.4478 16.1481 37.702 15.8857C37.8743 15.7216 37.9071 15.6068 37.9071 15.1967C37.9071 14.7292 37.9153 14.7045 38.1367 14.6635C38.5304 14.5733 39.1948 14.1386 39.4983 13.7695C39.9904 13.1625 40.1545 12.7032 40.1627 11.9076C40.1627 11.276 40.1381 11.153 39.892 10.6609C39.4327 9.71762 38.6125 9.16807 37.4806 9.04504C36.7916 8.96302 36.4553 8.82358 36.1518 8.46269C35.5366 7.72449 35.7745 6.58438 36.6357 6.16607C37.6036 5.69855 38.6289 6.2645 38.8093 7.36359C38.9077 7.94595 39.0964 8.16741 39.5147 8.16741C39.7444 8.16741 39.8592 8.10999 40.0068 7.93775C40.2447 7.66707 40.2611 7.33899 40.0478 6.66641C39.7936 5.83799 39.244 5.23923 38.4238 4.87833L37.9071 4.65687V4.21395C37.9071 3.68901 37.661 3.37733 37.2509 3.37733C37.0951 3.37733 36.9228 3.45115 36.7998 3.58238Z" fill="#2C2C2C"/>
                                <path d="M17.2131 12.2348C16.2124 12.489 15.5645 13.2846 15.5645 14.2853C15.5645 16.221 18.0169 17.1151 19.3293 15.6633C19.4933 15.4828 19.682 15.2121 19.7476 15.0563C19.9198 14.638 19.8952 13.826 19.6902 13.4159C19.5015 13.014 18.9848 12.5136 18.5993 12.3578C18.2302 12.2019 17.5822 12.1445 17.2131 12.2348ZM18.1317 13.6701C18.8535 14.0392 18.5008 15.0235 17.6478 15.0235C17.2951 15.0235 16.9096 14.638 16.9096 14.2853C16.9096 13.9326 17.2951 13.5471 17.6478 13.5471C17.7872 13.5471 18.0087 13.6045 18.1317 13.6701Z" fill="#2C2C2C"/>
                                <path d="M17.2541 18.1493C16.2288 18.3544 15.4004 19.4781 15.5563 20.4623C15.6383 20.9627 15.9992 21.5778 16.3683 21.8485C16.7046 22.0946 17.369 22.3242 17.7299 22.3242C18.4762 22.3242 19.3539 21.7583 19.6984 21.0611C19.8952 20.6428 19.9198 19.8554 19.7394 19.4288C19.3539 18.502 18.2712 17.9443 17.2541 18.1493ZM18.1318 19.5765C18.263 19.6421 18.4106 19.7979 18.4598 19.9292C18.7797 20.7002 17.7545 21.2907 17.1475 20.692C16.5077 20.044 17.3033 19.1418 18.1318 19.5765Z" fill="#2C2C2C"/>
                                <path d="M21.6259 19.7394C21.3717 19.9854 21.3635 20.3381 21.5931 20.6334L21.7572 20.8467H26.5965H31.4358L31.6326 20.6416C31.7638 20.5186 31.8377 20.3463 31.8377 20.1905C31.8377 20.0347 31.7638 19.8624 31.6326 19.7394L31.4358 19.5343H26.6293H21.8228L21.6259 19.7394Z" fill="#2C2C2C"/>
                                <path d="M16.9095 24.154C16.7537 24.2032 16.4338 24.4329 16.1959 24.6625C15.4659 25.3761 15.3429 26.2619 15.8515 27.156C16.2206 27.7958 16.9834 28.2305 17.7462 28.2305C18.2383 28.2305 18.8863 27.9434 19.2636 27.5579C19.6983 27.115 19.8623 26.7213 19.8623 26.1225C19.8541 24.9168 18.9519 24.0392 17.7298 24.0556C17.4345 24.0638 17.0654 24.1048 16.9095 24.154ZM18.1317 25.4827C18.2629 25.5484 18.4105 25.7042 18.4597 25.8354C18.7796 26.6064 17.7544 27.197 17.1474 26.5982C16.7783 26.2291 16.8439 25.737 17.3032 25.4909C17.5903 25.3351 17.8446 25.3269 18.1317 25.4827Z" fill="#2C2C2C"/>
                                <path d="M21.9132 25.4997C21.4457 25.6719 21.2735 26.2296 21.577 26.5987L21.7328 26.7956L26.4737 26.8202C29.7627 26.8366 31.2883 26.812 31.436 26.7546C31.8543 26.5823 31.9527 26.0738 31.641 25.7129L31.4442 25.4832L26.7361 25.4668C24.1524 25.4586 21.9789 25.475 21.9132 25.4997Z" fill="#2C2C2C"/>
                            </svg>
                        </span>
                        <h3 class="dm-sans font-medium text-lg text-gray-12">{{ __('Billing Address') }}</h3>
                    </div>
                    <div class="mt-8">
                        <p class="roboto-medium font-medium text-gray-10 mb-1.5 break-all">{{ $billingAddress->first_name . ' ' . $billingAddress->last_name }}</p>
                        <p class="roboto-medium font-medium text-gray-10 mb-1.5 break-all"> {{ $billingAddress->phone }}
                        </p>
                        <p class="roboto-medium font-medium text-gray-10 mb-1.5 break-all"> {{ $billingAddress->address_1 }}
                            {{ !empty($billingAddress->address_2) ? ', ' . $billingAddress->address_2 . ',' : '' }}
                            {{ $billingAddress->city }}</p>
                        <p class="roboto-medium font-medium text-gray-10 mb-1.5 break-all">{{ __('Postcode') }}: {{ $billingAddress->zip }}</p>
                        <p class="roboto-medium font-medium text-gray-10 mb-1.5 break-all">{{ __('State') }}: {{ $billingAddress->state }}</p>
                        <p class="roboto-medium font-medium text-gray-10 mb-1.5 break-all">{{ __('Country') }}:{{ $billingAddress->country }}</p>
                    </div>
                    <p class="mt-30p dm-sans font-medium text-gray-12 break-all">{{ __('Email') }}: {{ $billingAddress->email }}</p>
                </div>
            </div>
        </div>
    <div class="my-16">
        <div class="overflow-x-auto hidden lg:block rounded-sm">
            <table class="w-full bg-white overflow-hidden">
                <thead>
                    @if (isActive('Shop'))
                        @php $shop = true; @endphp
                    @endif
                    <tr class="bg-gray-11 border border-gray-2 dark:bg-gray-2 {{ languageDirection() == 'ltr' ? 'text-left' : 'text-right' }}">
                        <th class="pl-10 py-4 w-532p text-gray-12 dm-sans font-medium xl:text-xl md:text-base dark:text-gray-2 {{ languageDirection() == 'ltr' ? 'pl-10' : 'pr-10' }}">
                            {{ __('Products') }}
                        </th>
                        <th class="py-4 px-6 w-44 text-gray-12 dm-sans font-medium xl:text-xl md:text-base dark:text-gray-2">
                            {{ __('Status') }}</th>
                        <th class="px-6 py-4 w-44 text-gray-12 dm-sans font-medium xl:text-xl md:text-base dark:text-gray-2">
                            {{ __('Cost') }}
                        </th>
                        <th class="px-6 w-44 py-4 text-gray-12 dm-sans font-medium xl:text-xl md:text-base dark:text-gray-2">
                            {{ __('Quantity') }}</th>
                        <th class="px-6 w-44 py-4 text-gray-12 dm-sans font-medium xl:text-xl md:text-base dark:text-gray-2">
                            {{ __('Amount') }}</th>
                    </tr>
                </thead>
                <tbody class="border border-gray-2">
                    @foreach ($detailGroups as $group)
                        @foreach ($group as $detail)
                            @if ($loop->iteration == 1)
                        <tr class="border-t border-gray-2">
                        <td colspan="5" class="mt-7 pb-8 roboto-medium font-medium text-gray-10 flex items-center dark:text-gray-2 {{ languageDirection() == 'ltr' ? 'pl-10' : 'pr-10' }}">{{ __('Seller') }}: {{ optional($detail->vendor)->name }}
                        </td>
                        </tr>
                        @endif
                        @endforeach
                        @foreach ($group as $detail)
                            <tr>
                                <td class="w-532p pb-8">
                                    @php
                                    $opName = '';
                                    if ($detail->payloads != null) {
                                        $option = (array)json_decode($detail->payloads);
                                        $itemCount = count($option);
                                        $i = 0;
                                        foreach ($option as $key => $value) {
                                            $opName .= $key . ': ' . $value . (++$i == $itemCount ? '' : ', ');
                                        }
                                    }

                                    $productInfo = $orderAction->getProductInfo($detail);
                                    $purchaseNote = $detail->productMeta->where('key', 'meta_purchase_note')->first();
                                        @endphp
                                    <div class="justify-left w-max items-center flex {{ languageDirection() == 'ltr' ? 'pl-10' : 'pr-10' }}">
                                        <span class="bg-gray-17 h-16 w-16 p-2 rounded-sm flex justify-center items-center">
                                            <img src="{{ $productInfo['image'] }}" alt="item" class="h-full w-full neg-transition-scale"/>
                                        </span>
                                        <div class="flex flex-col {{ languageDirection() == 'ltr' ? 'ml-8' : 'mr-8' }}">
                                            <a class="dm-sans whitespace-normal w-430p font-medium text-gray-12 dark:text-gray-2"href="{{ $productInfo['url'] }}"> {{ trimWords($detail->product_name, 85) }}</a>
                                            <p class="text-sm mt-2 roboto-medium font-medium text-gray-10">{{!empty($opName) ? $opName : '' }}</p>
                                        </div>
                                    </div>
                                    @if (!empty($purchaseNote) && !empty($purchaseNote->value) && $purchaseNote->value != '')
                                        <span class="dm-sans font-medium text-gray-12 whitespace-normal flex items-center dark:text-gray-2 w-532p {{ languageDirection() == 'ltr' ? 'pl-10' : 'pr-10' }}" title="{{ $purchaseNote->value }}">
                                            {{ trimWords($purchaseNote->value, 50) }}
                                        </span>
                                    @endif
                                </td>
                                <td class="w-44 pb-8">
                                    <span class="roboto-medium whitespace-nowrap font-medium text-gray-10 px-6 py-4 dark:text-gray-2">{{ optional($detail->orderStatus)->name }}
                                    </span>
                                </td>
                                <td class="w-44 pb-8">
                                    <span class="roboto-medium font-medium text-gray-12 px-6 py-4 whitespace-nowrap dark:text-gray-2">
                                        {{ formatNumber($detail->price, optional($order->currency)->symbol) }}
                                    </span>
                                </td>
                                <td class="w-44 pb-8">
                                    <span class="roboto-medium font-medium text-gray-12 whitespace-nowrap px-6 py-4 dark:text-gray-2">
                                        x {{ formatCurrencyAmount($detail->quantity) }}
                                    </span>
                                </td>
                                <td class="w-max pb-8">
                                  <div class="flex justify-left items-center">
                                        <span class="roboto-medium whitespace-nowrap font-medium text-gray-12 px-6 py-4 dark:text-gray-2">
                                            {{ formatNumber($detail->quantity * $detail->price, optional($order->currency)->symbol) }}
                                        </span>
                                        @if ($detail->isRefundable() && preference('order_refund'))
                                            <a class="text-gray-10 text-sm roboto-medium font-medium mr-5 w-24 bg-gray-11 py-1.5 rounded-sm px-2.5 flex {{ languageDirection() == 'ltr' ? 'ml-6' : 'mr-6' }}" href="{{ route('site.createRefundRequest', ['order_id' => $order->id, 'product_id' => $detail->product_id]) }}">
                                                <svg class=" {{ languageDirection() == 'ltr' ? 'mr-2.5' : 'ml-2.5' }}" xmlns="http://www.w3.org/2000/svg" width="14" height="16" viewBox="0 0 14 16" fill="none">
                                                    <path d="M6.54542 0.395768C6.34304 0.613717 6.17491 0.800529 6.17491 0.809871C6.17491 0.822325 6.42399 1.06829 6.72912 1.35785C7.03113 1.64742 7.28022 1.89961 7.28022 1.91518C7.28022 1.93386 7.19615 1.93698 7.0685 1.92452C6.83809 1.90273 6.26831 1.9432 5.83242 2.01793C3.64359 2.38533 1.73187 3.79576 0.741764 5.76664C0.200006 6.85016 -0.0335097 7.9181 0.00385293 9.15418C0.0349884 10.2159 0.243596 11.0566 0.710629 12.0093C2.28608 15.2318 6.00989 16.7388 9.39432 15.5214C9.83644 15.3657 10.456 15.0512 10.8764 14.771C12.6417 13.6003 13.7471 11.7664 13.9775 9.63367C14.021 9.204 13.9993 8.27616 13.9308 7.8496C13.8716 7.48221 13.7315 6.93422 13.6007 6.5606C13.3703 5.90364 12.8877 5.05052 12.4238 4.48386C12.1 4.08532 11.3527 3.38166 11.2967 3.41591C11.2811 3.42525 11.1037 3.6432 10.9044 3.90162L10.5401 4.37177L10.7394 4.54613C12.9749 6.4921 13.4108 9.71462 11.7637 12.165C11.1441 13.0897 10.207 13.8463 9.15769 14.2697C7.63516 14.8862 5.94762 14.8208 4.44689 14.086C3.51594 13.6315 2.67216 12.8686 2.12107 11.9844C1.02821 10.219 0.950372 8.07689 1.91557 6.23367C2.65037 4.83258 3.98608 3.76774 5.51795 3.36921C5.71099 3.31628 6.00677 3.25401 6.17802 3.2291C6.47381 3.18551 7.28022 3.16371 7.28022 3.20108C7.28022 3.21042 7.05293 3.45639 6.77582 3.74595C6.4956 4.03862 6.2652 4.2877 6.25897 4.30016C6.24963 4.32818 6.99688 5.05052 7.03425 5.05052C7.07161 5.05052 9.47527 2.52544 9.47527 2.48496C9.47527 2.46317 8.99267 1.98679 8.40109 1.42635C7.80952 0.862801 7.23351 0.311703 7.12143 0.202728L6.91593 0.000347137L6.54542 0.395768Z" fill="#898989"/>
                                                    <path d="M6.56442 6.0743C6.56442 6.41679 6.57687 6.395 6.34024 6.43547C6.02577 6.49152 5.61167 6.70012 5.36882 6.91807C4.9516 7.30104 4.81772 7.958 5.04189 8.54957C5.12596 8.77997 5.41552 9.07888 5.66772 9.2003C5.91991 9.32173 6.35892 9.43071 6.82907 9.48675C7.80673 9.60818 8.18346 9.78876 8.18346 10.1344C8.18346 10.4395 7.9624 10.645 7.53585 10.7477C7.3179 10.7976 6.87266 10.8007 6.65783 10.7477C6.27175 10.6606 5.90435 10.4177 5.7798 10.1748C5.74556 10.1063 5.71131 10.041 5.70508 10.0347C5.70197 10.0285 5.47156 10.1188 5.19757 10.234C4.83951 10.3866 4.69629 10.4613 4.69629 10.4955C4.69629 10.5236 4.7679 10.6606 4.85197 10.8007C5.05123 11.1245 5.34391 11.3922 5.67706 11.5573C5.91991 11.6756 6.34647 11.8063 6.49281 11.8063C6.56131 11.8063 6.56131 11.8157 6.57065 12.1551L6.57999 12.5069L7.1342 12.5162L7.6853 12.5225V12.1519V11.7814L7.83475 11.7628C8.40453 11.6818 8.98053 11.2988 9.20471 10.8474C9.33548 10.5827 9.37595 10.3523 9.35727 10.0161C9.33236 9.5677 9.18603 9.25635 8.88401 9.00726C8.55398 8.73327 8.13053 8.6025 7.15599 8.46239C6.38383 8.35031 6.20947 8.29115 6.11295 8.10122C5.9635 7.81166 6.20013 7.51276 6.6516 7.41935C7.21515 7.30104 7.83163 7.45672 8.13053 7.78675L8.26442 7.93932L8.73768 7.72137L9.21094 7.50031L9.12376 7.34463C9.00544 7.12979 8.73145 6.83712 8.51661 6.69701C8.34537 6.58804 8.12742 6.50086 7.81918 6.4199L7.6853 6.38566V6.07741V5.76606H7.12486H6.56442V6.0743Z" fill="#898989"/>
                                                </svg>{{ __('Refund') }}
                                            </a>
                                        @endif
                                        @if ($detail->isRefunded() && preference('order_refund'))
                                            <div class="roboto-medium font-medium text-gray-12 py-2 px-6 flex justify-left items-center">
                                                {{ __('Refunded') }}
                                            </div>
                                        @endif
                                  </div>
                                </td>
                            </tr>
                        @endforeach
                    @endforeach
                </tbody>
                <tfoot>
                    <tr class="focus-within:bg-gray-200 border border-gray-2 overflow-hidden">
                        <td colspan="2" class="dm-sans font-medium text-gray-12 px-6 py-18p"></td>
                        @if (isActive('Shop'))
                            <td class="dm-sans font-medium text-gray-12 px-6 py-18p"></td>
                        @endif
                        @php
                            $couponOffer = isset($order->couponRedeems) && $order->couponRedeems->sum('discount_amount') > 0 && isActive('Coupon') ? $order->couponRedeems->sum('discount_amount') : 0;
                        @endphp
                        <td class="dm-sans font-medium text-gray-12 px-6 py-18p">{{ __('Subtotal') }}:</td>
                        <td class=" dm-sans font-medium text-gray-12 px-6 py-18p">{{ formatNumber($order->total + $order->other_discount_amount + $couponOffer - ($order->shipping_charge + $order->tax_charge), optional($order->currency)->symbol) }}</td>
                    </tr>
                    <tr class="border border-gray-2"></tr>
                    <tr class="focus-within:bg-gray-200 overflow-hidden border border-gray-2">
                        <td colspan="2" class="dm-sans font-medium text-gray-12 px-6 py-18p"></td>
                        @if (isActive('Shop'))
                            <td class="dm-sans font-medium text-gray-12 px-6 py-18p"></td>
                        @endif
                        <td class="dm-sans font-medium text-gray-12 px-6 py-18p whitespace-nowrap">{{ __('Shipping') }} {{ !is_null($order->shipping_title) ? "( ". $order->shipping_title . " )" : null }}:</td>
                        <td class="dm-sans font-medium text-gray-12 px-6 py-18p">{{ formatNumber($order->shipping_charge, optional($order->currency)->symbol) }}</td>
                    </tr>
                    @if(preference("taxes") == 1)
                    <tr class="focus-within:bg-gray-200 overflow-hidden border border-gray-2">
                        <td colspan="2" class="dm-sans font-medium text-gray-12 px-6 py-18p"></td>
                        @if (isActive('Shop'))
                            <td class="dm-sans font-medium text-gray-12 px-6 py-18p"></td>
                        @endif
                        <td class="dm-sans font-medium text-gray-12 px-6 py-18p">{{ __('Tax') }}:</td>
                        <td class="dm-sans font-medium text-gray-12 px-6 py-18p">{{ formatNumber($order->tax_charge, optional($order->currency)->symbol) }}</td>
                    </tr>
                    @endif
                    @if ($couponOffer > 0)
                        <tr class="focus-within:bg-gray-200 overflow-hidden border border-gray-2">
                            <td colspan="2" class="dm-sans font-medium text-gray-12 px-6 py-18p"></td>
                            @if (isActive('Shop'))
                                <td class="dm-sans font-medium text-gray-12 px-6 py-18p"></td>
                            @endif
                            <td class="dm-sans font-medium text-gray-12 px-6 py-18p">{{ __('Coupon offer') }}:</td>
                            <td class="dm-sans font-medium text-gray-12 px-6 py-18p">{{ formatNumber($couponOffer, optional($order->currency)->symbol) }}</td>
                        </tr>
                    @endif
                    @if ($order->other_discount_amount > 0)
                        <tr class="focus-within:bg-gray-200 overflow-hidden border border-gray-2">
                            <td colspan="2" class="dm-sans font-medium text-gray-12 px-6 py-18p"></td>
                            @if (isActive('Shop'))
                                <td class="dm-sans font-medium text-gray-12 px-6 py-18p"></td>
                            @endif
                            <td class="dm-sans font-medium text-gray-12 px-6 py-18p">{{ __('Discount') }}:</td>
                            <td class="dm-sans font-medium text-gray-12 px-6 py-18p">{{ formatNumber($order->other_discount_amount, optional($order->currency)->symbol) }}</td>
                        </tr>
                    @endif
                    <tr class="focus-within:bg-gray-200 overflow-hidden border border-gray-2">
                        <td colspan="2" class="dm-sans font-medium text-gray-12 px-6 py-18p"></td>
                        @if (isActive('Shop'))
                            <td class="dm-sans font-medium text-gray-12 px-6 py-18p"></td>
                        @endif
                        <td class="dm-sans font-medium text-gray-12 px-6 py-18p">{{ __('Grand Total') }}:</td>
                        <td class="dm-sans font-medium text-gray-12 px-6 py-18p">{{ formatNumber($order->total, optional($order->currency)->symbol) }}</td>
                    </tr>
                </tfoot>
            </table>
            <br>
            @if (!empty($order->note))
                {{ __('Note') }}: {{ $order->note }}
            @endif
        </div>
    </div>
        <div class="block lg:hidden mt-30p">
            <p class="text-gray-12 text-lg dm-bold font-bold text-left uppercase">{{ __('Your items') }}</p>
            @foreach ($detailGroups as $group)
            <div class="mt-3 mb-5 border border-gray-2 rounded-md">
                @foreach ($group as $detail)
                    @php
                        $opName = '';
                        if ($detail->payloads != null) {
                            $option = (array)json_decode($detail->payloads);
                            $itemCount = count($option);
                            $i = 0;
                            foreach ($option as $key => $value) {
                                $opName .= $key . ': ' . $value . (++$i == $itemCount ? '' : ', ');
                            }
                        }
                        $productInfo = $orderAction->getProductInfo($detail);
                    @endphp
                    @if ($loop->first)
                        <div class="flex justify-between mx-4 mt-4">
                            <div>
                                <p class="roboto-medium font-medium text-gray-12 text-13 leading-none flex items-center dark:text-gray-2">{{ __('Seller') }}: {{ optional($detail->vendor)->name }}
                                </p>
                                <span class="leading-none pt-1 roboto-medium font-medium text-gray-10 text-xs dark:text-gray-2">{{ __('Status') }}:{{ optional($detail->orderStatus)->name }}
                                </span>
                            </div>
                        </div>
                    @endif
                    <div>
                        <div class="flex justify-between items-center mx-4 mb-4">
                            <div class="flex justify-center items-center mt-4">
                                <span class="w-12 h-12 p-1.5 flex items-center bg-gray-17 rounded {{ languageDirection() == 'ltr' ? 'mr-3' : 'ml-3' }}">
                                    <img src="{{ $productInfo['image'] }}" alt="item"class="h-full w-full object-cover"/>
                                </span>
                                <div>
                                    <p class="roboto-medium text-xs leading-none font-medium text-gray-12 flex items-center dark:text-gray-2">{{ trimWords($detail->product_name, 25) }}</p>
                                    <p class="text-xss mt-5p roboto-medium leading-none font-medium text-gray-10">{{ !empty($opName) ? $opName : '' }}</p>
                                    <p class="dm-sans mt-5p font-medium text-xss text-gray-12">
                                        <span class="{{ languageDirection() == 'ltr' ? 'mr-1' : 'ml-1' }}">{{ formatNumber($detail->price, optional($order->currency)->symbol) }}</span>
                                        <span class="{{ languageDirection() == 'ltr' ? 'mr-1' : 'ml-1' }}">x {{ formatCurrencyAmount($detail->quantity) }} </span>
                                        <span> ( {{ formatNumber($detail->quantity * $detail->price, optional($order->currency)->symbol) }})</span>
                                    </p>
                                </div>
                            </div>
                            @if ($detail->isRefundable() && preference('order_refund'))
                            <div>
                                <a href="{{ route('site.createRefundRequest', ['order_id' => $order->id, 'product_id' => $detail->product_id]) }}"
                                    class="text-gray-10 justify-center items-center flex border border-gray-2 p-1.5 rounded-sm text-sm">
                                    <svg class="{{ languageDirection() == 'ltr' ? 'mr-1' : 'ml-1' }} mt-0.5" xmlns="http://www.w3.org/2000/svg" width="13" height="14"
                                        viewBox="0 0 14 16" fill="none">
                                        <path d="M6.54542 0.395768C6.34304 0.613717 6.17491 0.800529 6.17491 0.809871C6.17491 0.822325 6.42399 1.06829 6.72912 1.35785C7.03113 1.64742 7.28022 1.89961 7.28022 1.91518C7.28022 1.93386 7.19615 1.93698 7.0685 1.92452C6.83809 1.90273 6.26831 1.9432 5.83242 2.01793C3.64359 2.38533 1.73187 3.79576 0.741764 5.76664C0.200006 6.85016 -0.0335097 7.9181 0.00385293 9.15418C0.0349884 10.2159 0.243596 11.0566 0.710629 12.0093C2.28608 15.2318 6.00989 16.7388 9.39432 15.5214C9.83644 15.3657 10.456 15.0512 10.8764 14.771C12.6417 13.6003 13.7471 11.7664 13.9775 9.63367C14.021 9.204 13.9993 8.27616 13.9308 7.8496C13.8716 7.48221 13.7315 6.93422 13.6007 6.5606C13.3703 5.90364 12.8877 5.05052 12.4238 4.48386C12.1 4.08532 11.3527 3.38166 11.2967 3.41591C11.2811 3.42525 11.1037 3.6432 10.9044 3.90162L10.5401 4.37177L10.7394 4.54613C12.9749 6.4921 13.4108 9.71462 11.7637 12.165C11.1441 13.0897 10.207 13.8463 9.15769 14.2697C7.63516 14.8862 5.94762 14.8208 4.44689 14.086C3.51594 13.6315 2.67216 12.8686 2.12107 11.9844C1.02821 10.219 0.950372 8.07689 1.91557 6.23367C2.65037 4.83258 3.98608 3.76774 5.51795 3.36921C5.71099 3.31628 6.00677 3.25401 6.17802 3.2291C6.47381 3.18551 7.28022 3.16371 7.28022 3.20108C7.28022 3.21042 7.05293 3.45639 6.77582 3.74595C6.4956 4.03862 6.2652 4.2877 6.25897 4.30016C6.24963 4.32818 6.99688 5.05052 7.03425 5.05052C7.07161 5.05052 9.47527 2.52544 9.47527 2.48496C9.47527 2.46317 8.99267 1.98679 8.40109 1.42635C7.80952 0.862801 7.23351 0.311703 7.12143 0.202728L6.91593 0.000347137L6.54542 0.395768Z" fill="#898989"/>
                                        <path d="M6.56442 6.0743C6.56442 6.41679 6.57687 6.395 6.34024 6.43547C6.02577 6.49152 5.61167 6.70012 5.36882 6.91807C4.9516 7.30104 4.81772 7.958 5.04189 8.54957C5.12596 8.77997 5.41552 9.07888 5.66772 9.2003C5.91991 9.32173 6.35892 9.43071 6.82907 9.48675C7.80673 9.60818 8.18346 9.78876 8.18346 10.1344C8.18346 10.4395 7.9624 10.645 7.53585 10.7477C7.3179 10.7976 6.87266 10.8007 6.65783 10.7477C6.27175 10.6606 5.90435 10.4177 5.7798 10.1748C5.74556 10.1063 5.71131 10.041 5.70508 10.0347C5.70197 10.0285 5.47156 10.1188 5.19757 10.234C4.83951 10.3866 4.69629 10.4613 4.69629 10.4955C4.69629 10.5236 4.7679 10.6606 4.85197 10.8007C5.05123 11.1245 5.34391 11.3922 5.67706 11.5573C5.91991 11.6756 6.34647 11.8063 6.49281 11.8063C6.56131 11.8063 6.56131 11.8157 6.57065 12.1551L6.57999 12.5069L7.1342 12.5162L7.6853 12.5225V12.1519V11.7814L7.83475 11.7628C8.40453 11.6818 8.98053 11.2988 9.20471 10.8474C9.33548 10.5827 9.37595 10.3523 9.35727 10.0161C9.33236 9.5677 9.18603 9.25635 8.88401 9.00726C8.55398 8.73327 8.13053 8.6025 7.15599 8.46239C6.38383 8.35031 6.20947 8.29115 6.11295 8.10122C5.9635 7.81166 6.20013 7.51276 6.6516 7.41935C7.21515 7.30104 7.83163 7.45672 8.13053 7.78675L8.26442 7.93932L8.73768 7.72137L9.21094 7.50031L9.12376 7.34463C9.00544 7.12979 8.73145 6.83712 8.51661 6.69701C8.34537 6.58804 8.12742 6.50086 7.81918 6.4199L7.6853 6.38566V6.07741V5.76606H7.12486H6.56442V6.0743Z" fill="#898989"/>
                                    </svg>{{ __('Refund') }}
                                </a>
                            </div>
                            @endif
                            @if ($detail->isRefunded() && preference('order_refund'))
                                <div class="mt-4 py-2 flex justify-left items-center">{{ __('Refunded') }}
                                </div>
                            @endif
                        </div>
                    </div>
                @endforeach
            </div>
            @endforeach
        </div>
    </div>
@endsection
