<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudBuild;

class TaskRef extends \Google\Collection
{
  protected $collection_key = 'params';
  /**
   * @var string
   */
  public $customTask;
  /**
   * @var string
   */
  public $name;
  protected $paramsType = Param::class;
  protected $paramsDataType = 'array';
  /**
   * @var string
   */
  public $resolver;

  /**
   * @param string
   */
  public function setCustomTask($customTask)
  {
    $this->customTask = $customTask;
  }
  /**
   * @return string
   */
  public function getCustomTask()
  {
    return $this->customTask;
  }
  /**
   * @param string
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param Param[]
   */
  public function setParams($params)
  {
    $this->params = $params;
  }
  /**
   * @return Param[]
   */
  public function getParams()
  {
    return $this->params;
  }
  /**
   * @param string
   */
  public function setResolver($resolver)
  {
    $this->resolver = $resolver;
  }
  /**
   * @return string
   */
  public function getResolver()
  {
    return $this->resolver;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(TaskRef::class, 'Google_Service_CloudBuild_TaskRef');
